/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.kernel.impl.traversal.TraversalDescriptionImpl;
import org.springframework.data.annotation.TypeAlias;
import org.springframework.data.neo4j.annotation.Fetch;
import org.springframework.data.neo4j.annotation.GraphId;
import org.springframework.data.neo4j.annotation.GraphProperty;
import org.springframework.data.neo4j.annotation.GraphTraversal;
import org.springframework.data.neo4j.annotation.Indexed;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.RelatedTo;
import org.springframework.data.neo4j.core.FieldTraversalDescriptionBuilder;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.model.IGroup;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.support.index.IndexType;
import org.springframework.util.ObjectUtils;

@NodeEntity
@TypeAlias(value="g")
public class Group
implements IGroup {
    public static final String OTHER_NAME_INDEX = "other_name";
    public static final String SEARCH_GROUPS_INDEX = "search_groups";
    public static final String SEARCH_GROUPS_INDEX_BUG = "search-groups";
    @RelatedTo(direction=Direction.OUTGOING)
    private Collection<Person> persons;
    @Fetch
    @RelatedTo
    private Collection<Person> fetchedPersons;
    @RelatedTo(type="persons", elementClass=Person.class)
    private Iterable<Person> readOnlyPersons;
    @GraphTraversal(traversal=PeopleTraversalBuilder.class, params={"persons"})
    private Iterable<Person> people;
    @GraphProperty
    @Indexed
    private String name;
    @GraphProperty
    @Indexed
    private Boolean admin;
    @GraphProperty
    private String unindexedName;
    private String unindexedName2;
    @GraphProperty
    @Indexed(indexName="search_groups", indexType=IndexType.FULLTEXT)
    private String fullTextName;
    @GraphProperty
    @Indexed(indexName="search-groups", indexType=IndexType.FULLTEXT)
    private String fullTextNameBug;
    @Indexed(fieldName="other_name")
    private String otherName;
    @Indexed(level=Indexed.Level.GLOBAL)
    private String globalName;
    @Indexed(level=Indexed.Level.CLASS)
    private String classLevelName;
    @Indexed(level=Indexed.Level.INSTANCE)
    private String indexLevelName;
    @GraphId
    private Long id;

    public String getFullTextNameBug() {
        return this.fullTextNameBug;
    }

    public void setFullTextNameBug(String fullTextNameBug) {
        this.fullTextNameBug = fullTextNameBug;
    }

    public String getFullTextName() {
        return this.fullTextName;
    }

    public void setFullTextName(String fullTextName) {
        this.fullTextName = fullTextName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPersons(Set<Person> persons) {
        this.persons = persons;
    }

    public void addPerson(Person person) {
        if (this.persons == null) {
            this.persons = new HashSet<Person>();
        }
        this.persons.add(person);
    }

    public Collection<Person> getPersons() {
        return this.persons;
    }

    public Iterable<Person> getReadOnlyPersons() {
        return this.readOnlyPersons;
    }

    public void setReadOnlyPersons(Iterable<Person> p) {
        this.readOnlyPersons = p;
    }

    public Iterable<Person> getPeople() {
        return this.people;
    }

    public void setOtherName(String otherName) {
        this.otherName = otherName;
    }

    public Long getId() {
        return this.id;
    }

    public String getUnindexedName() {
        return this.unindexedName;
    }

    public void setUnindexedName(String unindexedName) {
        this.unindexedName = unindexedName;
    }

    public String getUnindexedName2() {
        return this.unindexedName2;
    }

    public void setUnindexedName2(String unindexedName2) {
        this.unindexedName2 = unindexedName2;
    }

    public void setGlobalName(String globalName) {
        this.globalName = globalName;
    }

    public void setClassLevelName(String classLevelName) {
        this.classLevelName = classLevelName;
    }

    public void setIndexLevelName(String indexLevelName) {
        this.indexLevelName = indexLevelName;
    }

    public Boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(Boolean admin) {
        this.admin = admin;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        Group that = (Group)obj;
        return ObjectUtils.nullSafeEquals((Object)this.id, (Object)that.id);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.id);
    }

    public Collection<Person> getFetchedPersons() {
        return this.fetchedPersons;
    }

    private static class PeopleTraversalBuilder
    implements FieldTraversalDescriptionBuilder {
        private PeopleTraversalBuilder() {
        }

        public TraversalDescription build(Object start, Neo4jPersistentProperty property, String ... params) {
            return new TraversalDescriptionImpl().relationships((RelationshipType)DynamicRelationshipType.withName((String)params[0])).evaluator(Evaluators.excludeStartPosition());
        }
    }
}

