/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Ignore;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.util.FileUtils;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.data.neo4j.model.Car;
import org.springframework.data.neo4j.model.Volvo;
import org.springframework.data.neo4j.support.Neo4jTemplate;

@Ignore
public class ReadWriteTests {
    public static void main(String[] args) throws IOException {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("classpath:ReadWriteTests-context.xml");
        boolean delete = false;
        try {
            Neo4jTemplate template = (Neo4jTemplate)ctx.getBean(Neo4jTemplate.class);
            Car car = ReadWriteTests.findOne(template);
            if (car != null) {
                delete = true;
                Assert.assertEquals(Volvo.class, car.getClass());
            } else {
                Transaction tx = template.getGraphDatabase().beginTx();
                Volvo volvo = (Volvo)template.save((Object)new Volvo());
                Assert.assertEquals((long)1L, (long)volvo.id.intValue());
                tx.success();
                tx.finish();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            delete = true;
            throw new RuntimeException(e);
        }
        finally {
            ctx.close();
            if (delete) {
                FileUtils.deleteRecursively((File)new File("target/read-write.db"));
            }
        }
    }

    private static Car findOne(Neo4jTemplate template) {
        try {
            return (Car)template.findOne(1L, Car.class);
        }
        catch (DataRetrievalFailureException nfe) {
            return null;
        }
    }
}

