/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.helpers.collection.IteratorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.conversion.EndResult;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.repository.FriendshipRepository;
import org.springframework.data.neo4j.repository.GroupRepository;
import org.springframework.data.neo4j.repository.PersonRepository;
import org.springframework.data.neo4j.repository.TestTeam;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.node.Neo4jHelper;
import org.springframework.test.context.CleanContextCacheTestExecutionListener;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=SpringJUnit4ClassRunner.class)
@TestExecutionListeners(value={CleanContextCacheTestExecutionListener.class, DependencyInjectionTestExecutionListener.class, TransactionalTestExecutionListener.class})
@ContextConfiguration(locations={"classpath:org/springframework/data/neo4j/repository/GraphRepositoryTests-context.xml"})
@Transactional
public class SpatialGraphRepositoryTests {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private Neo4jTemplate neo4jTemplate;
    @Autowired
    private PersonRepository personRepository;
    @Autowired
    GroupRepository groupRepository;
    @Autowired
    FriendshipRepository friendshipRepository;
    @Autowired
    PlatformTransactionManager transactionManager;
    private TestTeam testTeam;

    @BeforeTransaction
    public void cleanDb() {
        Neo4jHelper.cleanDb((Neo4jTemplate)this.neo4jTemplate);
    }

    @Before
    public void setUp() throws Exception {
        new TransactionTemplate(this.transactionManager).execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                SpatialGraphRepositoryTests.this.testTeam = new TestTeam();
                SpatialGraphRepositoryTests.this.testTeam.createSDGTeam(SpatialGraphRepositoryTests.this.personRepository, SpatialGraphRepositoryTests.this.groupRepository, SpatialGraphRepositoryTests.this.friendshipRepository);
            }
        });
    }

    @Test
    public void testFindPeopleWithinBoundingBox() {
        EndResult teamMembers = this.personRepository.findWithinBoundingBox("personLayer", 55.0, 15.0, 57.0, 17.0);
        Assert.assertThat((Object)IteratorUtil.asCollection((Iterable)teamMembers), (Matcher)Matchers.hasItems((Object[])new Person[]{this.testTeam.michael, this.testTeam.david}));
    }

    @Test
    public void testFindPeopleWithinPolygon() {
        EndResult teamMembers = this.personRepository.findWithinWellKnownText("personLayer", "POLYGON ((15 55, 15 57, 17 57, 17 55, 15 55))");
        Assert.assertThat((Object)IteratorUtil.asCollection((Iterable)teamMembers), (Matcher)Matchers.hasItems((Object[])new Person[]{this.testTeam.michael, this.testTeam.david}));
    }

    @Test
    public void testFindPeopleWithinDistance() {
        EndResult teamMembers = this.personRepository.findWithinDistance("personLayer", 16.0, 56.0, 70.0);
        Assert.assertThat((Object)IteratorUtil.asCollection((Iterable)teamMembers), (Matcher)Matchers.hasItems((Object[])new Person[]{this.testTeam.michael, this.testTeam.david}));
    }
}

