/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.query.Person;
import org.springframework.data.neo4j.repository.query.VariableContext;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;

public class VariableContextUnitTests {
    Neo4jMappingContext mappingContext;
    VariableContext context;

    @Before
    public void setUp() {
        this.mappingContext = new Neo4jMappingContext();
        this.context = new VariableContext();
    }

    @Test
    public void nameForSimplePropertyIsOwner() {
        Assert.assertThat((Object)this.context.getVariableFor(this.getPath("age")), (Matcher)CoreMatchers.is((Object)"person"));
    }

    @Test
    public void nameForPathViaEntityIsOwnerAndEntity() {
        Assert.assertThat((Object)this.context.getVariableFor(this.getPath("group.members")), (Matcher)CoreMatchers.is((Object)"person_group_members"));
    }

    @Test
    public void nameForEntityIsLowercaseSimpleClassName() {
        Assert.assertThat((Object)this.context.getVariableFor((Neo4jPersistentEntity)this.mappingContext.getPersistentEntity(Person.class)), (Matcher)CoreMatchers.is((Object)"person"));
    }

    @Test
    public void nameForEntityPropertyIsOwnerAndEntity() {
        PersistentPropertyPath<Neo4jPersistentProperty> gropPath = this.getPath("group");
        Assert.assertThat((Object)this.context.getVariableFor(gropPath), (Matcher)CoreMatchers.is((Object)"person_group"));
    }

    private PersistentPropertyPath<Neo4jPersistentProperty> getPath(String expression) {
        PropertyPath path = PropertyPath.from((String)expression, Person.class);
        return this.mappingContext.getPersistentPropertyPath(path);
    }
}

