/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.cypher;

import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.config.EnableNeo4jRepositories;
import org.springframework.data.neo4j.config.Neo4jConfiguration;
import org.springframework.data.neo4j.repository.query.cypher.RandomEntity;
import org.springframework.data.neo4j.repository.query.cypher.RandomEntityRepository;
import org.springframework.data.neo4j.support.node.Neo4jHelper;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
public class ParameterisedInTests {
    @Autowired
    GraphDatabaseService graphDatabaseService;
    @Autowired
    RandomEntityRepository randomEntityRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void before() {
        Neo4jHelper.cleanDb((GraphDatabaseService)this.graphDatabaseService, (boolean)true);
        Transaction transaction = this.graphDatabaseService.beginTx();
        try {
            this.randomEntityRepository.save(new RandomEntity("Huey"));
            this.randomEntityRepository.save(new RandomEntity("Dewey"));
            this.randomEntityRepository.save(new RandomEntity("Louie"));
            transaction.success();
        }
        finally {
            transaction.finish();
        }
    }

    @Test
    public void shouldSupportParametersAsIterable() throws Exception {
        Assert.assertThat((Object)this.randomEntityRepository.findUsingIterable(Arrays.asList(new String[]{"Huey"})).name, (Matcher)CoreMatchers.is((Object)"Huey"));
    }

    @Test
    public void shouldSupportParametersAsArray() throws Exception {
        Assert.assertThat((Object)this.randomEntityRepository.findUsingArray((String[])new String[]{"Dewey"}).name, (Matcher)CoreMatchers.is((Object)"Dewey"));
    }

    @Test
    public void shouldSupportParametersAsVarargs() throws Exception {
        Assert.assertThat((Object)this.randomEntityRepository.findUsingVarargs((String[])new String[]{"Louie"}).name, (Matcher)CoreMatchers.is((Object)"Louie"));
    }

    @Configuration
    @EnableNeo4jRepositories
    static class TestConfig
    extends Neo4jConfiguration {
        TestConfig() {
        }

        @Bean
        GraphDatabaseService graphDatabaseService() {
            return new ImpermanentGraphDatabase();
        }
    }
}

