/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.springframework.data.neo4j.support.DelegatingGraphDatabase;

public class DelegatingGraphDatabaseTests {
    private DelegatingGraphDatabase graphDatabase;
    private ImpermanentGraphDatabase gdb;

    @Before
    public void setUp() throws Exception {
        this.gdb = new ImpermanentGraphDatabase();
        this.graphDatabase = new DelegatingGraphDatabase((GraphDatabaseService)this.gdb);
    }

    @After
    public void tearDown() throws Exception {
        this.graphDatabase.shutdown();
    }

    @Test
    public void testGetOrCreateNode() throws Exception {
        Node node = this.graphDatabase.getOrCreateNode("user", "name", (Object)"David", MapUtil.map((Object[])new Object[]{"name", "David"}));
        Node node2 = this.graphDatabase.getOrCreateNode("user", "name", (Object)"David", MapUtil.map((Object[])new Object[]{"name", "David"}));
        Assert.assertEquals((Object)"David", (Object)node.getProperty("name"));
        Assert.assertEquals((Object)node, (Object)node2);
        Assert.assertEquals((Object)node, (Object)this.gdb.index().forNodes("user").get("name", (Object)"David").getSingle());
    }

    @Test
    public void testGetOrCreateRelationship() throws Exception {
        Transaction tx = this.gdb.beginTx();
        Node david = this.graphDatabase.createNode(MapUtil.map((Object[])new Object[]{"name", "David"}));
        Node michael = this.graphDatabase.createNode(MapUtil.map((Object[])new Object[]{"name", "Michael"}));
        Relationship rel1 = this.graphDatabase.getOrCreateRelationship("knows", "whom", (Object)"david_michael", david, michael, "KNOWS", MapUtil.map((Object[])new Object[]{"whom", "david_michael"}));
        Relationship rel2 = this.graphDatabase.getOrCreateRelationship("knows", "whom", (Object)"david_michael", david, michael, "KNOWS", MapUtil.map((Object[])new Object[]{"whom", "david_michael"}));
        Assert.assertEquals((Object)"david_michael", (Object)rel1.getProperty("whom"));
        Assert.assertEquals((Object)"KNOWS", (Object)rel1.getType().name());
        Assert.assertEquals((Object)david, (Object)rel1.getStartNode());
        Assert.assertEquals((Object)michael, (Object)rel1.getEndNode());
        Assert.assertEquals((Object)rel1, (Object)rel2);
        Assert.assertEquals((Object)rel1, (Object)this.gdb.index().forRelationships("knows").get("whom", (Object)"david_michael").getSingle());
        tx.success();
        tx.finish();
    }
}

