/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.unique;

import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.neo4j.unique.domain.Club;
import org.springframework.data.neo4j.unique.domain.InvalidClub;
import org.springframework.data.neo4j.unique.domain.UniqueClub;
import org.springframework.data.neo4j.unique.domain.UniqueNumericIdClub;
import org.springframework.data.neo4j.unique.repository.ClubRepository;
import org.springframework.data.neo4j.unique.repository.InvalidClubRepository;
import org.springframework.data.neo4j.unique.repository.UniqueClubRepository;
import org.springframework.data.neo4j.unique.repository.UniqueNumericIdClubRepository;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:unique-test-context.xml"})
@Transactional
public class UniqueEntityTests {
    @Autowired
    private ClubRepository clubRepository;
    @Autowired
    private UniqueClubRepository uniqueClubRepository;
    @Autowired
    private InvalidClubRepository invalidClubRepository;
    @Autowired
    protected GraphDatabaseService graphDatabaseService;
    @Autowired
    private UniqueNumericIdClubRepository uniqueNumericIdClubRepository;

    @Before
    public void setup() {
        this.clubRepository.deleteAll();
        this.uniqueClubRepository.deleteAll();
    }

    @Test
    public void shouldOnlyCreateSingleInstanceForUniqueNodeEntity() {
        UniqueClub club = new UniqueClub();
        club.setName("foo");
        this.uniqueClubRepository.save(club);
        club = new UniqueClub();
        club.setName("foo");
        this.uniqueClubRepository.save(club);
        Assert.assertEquals((long)1L, (long)this.uniqueClubRepository.count());
    }

    @Test(expected=MappingException.class)
    public void shouldFailOnNullPropertyValue() {
        UniqueClub club = new UniqueClub();
        club.setName(null);
        this.uniqueClubRepository.save(club);
    }

    @Test
    public void shouldOnlyCreateSingleInstanceForUniqueNumericNodeEntity() {
        UniqueNumericIdClub club = new UniqueNumericIdClub();
        club.setClubId(100L);
        this.uniqueNumericIdClubRepository.save(club);
        club = new UniqueNumericIdClub(100L);
        this.uniqueNumericIdClubRepository.save(club);
        Assert.assertEquals((long)1L, (long)this.uniqueNumericIdClubRepository.count());
    }

    @Test(expected=MappingException.class)
    public void shouldFailOnNullNumericPropertyValue() {
        UniqueNumericIdClub club = new UniqueNumericIdClub();
        club.setClubId(null);
        this.uniqueNumericIdClubRepository.save(club);
    }

    @Test
    public void shouldCreateMultipleInstancesForNonUniqueNodeEntity() {
        Club club = new Club();
        club.setName("foo");
        this.clubRepository.save(club);
        club = new Club();
        club.setName("foo");
        this.clubRepository.save(club);
        Assert.assertEquals((long)2L, (long)this.clubRepository.count());
    }

    @Test
    public void deletingUniqueNodeShouldRemoveItFromTheUniqueIndex() {
        UniqueClub club = new UniqueClub();
        club.setName("foo");
        this.uniqueClubRepository.save(club);
        Assert.assertEquals((long)1L, (long)this.uniqueClubRepository.count());
        this.uniqueClubRepository.delete(club);
        Assert.assertEquals((long)0L, (long)this.uniqueClubRepository.count());
    }

    @Test(expected=DataIntegrityViolationException.class)
    public void updatingToADuplicateValueShouldCauseAnException() {
        this.uniqueClubRepository.save(new UniqueClub("foo"));
        UniqueClub club2 = (UniqueClub)this.uniqueClubRepository.save(new UniqueClub("bar"));
        Assert.assertEquals((long)2L, (long)this.uniqueClubRepository.count());
        club2.setName("foo");
        this.uniqueClubRepository.save(club2);
    }

    @Test
    public void updatingToANewValueShouldKeepTheEntityUnique() {
        UniqueClub club = (UniqueClub)this.uniqueClubRepository.save(new UniqueClub("foo"));
        Assert.assertEquals((long)1L, (long)this.uniqueClubRepository.count());
        club.setName("bar");
        this.uniqueClubRepository.save(club);
        Assert.assertEquals((long)1L, (long)this.uniqueClubRepository.count());
        UniqueClub club2 = (UniqueClub)this.uniqueClubRepository.save(new UniqueClub("bar"));
        Assert.assertEquals((Object)club.getId(), (Object)club2.getId());
    }

    @Test
    public void updatingToANewValueShouldAlsoUpdateTheIndex() {
        UniqueClub club = (UniqueClub)this.uniqueClubRepository.save(new UniqueClub("foo"));
        Assert.assertEquals((long)1L, (long)this.uniqueClubRepository.count());
        Assert.assertEquals((Object)club.getId(), (Object)((UniqueClub)this.uniqueClubRepository.findByPropertyValue("name", "foo")).getId());
        club.setName("bar");
        this.uniqueClubRepository.save(club);
        Assert.assertEquals((Object)club.getId(), (Object)((UniqueClub)this.uniqueClubRepository.findByPropertyValue("name", "bar")).getId());
    }

    @Test(expected=MappingException.class)
    public void shouldThrowExceptionWhenMultipleUniqueSpecified() {
        InvalidClub club = new InvalidClub();
        this.invalidClubRepository.save(club);
    }
}

