/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.annotation.relatedto;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.Direction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.annotation.Fetch;
import org.springframework.data.neo4j.annotation.GraphId;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.RelatedTo;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:related-to-test-context.xml"})
@Transactional
public class BiDirectionalMappingTests {
    @Autowired
    Neo4jTemplate template;

    @Test
    public void testLoadBidirectional() throws Exception {
        TestEntityOne one = (TestEntityOne)this.template.save((Object)new TestEntityOne());
        TestEntityTwo entity = new TestEntityTwo();
        entity.test = one;
        this.template.save((Object)entity);
        TestEntityOne anotherOne = (TestEntityOne)this.template.findOne(one.id.longValue(), TestEntityOne.class);
        Assert.assertSame((Object)anotherOne, (Object)anotherOne.test.test);
    }

    @NodeEntity
    static class TestEntityTwo {
        @GraphId
        Long id;
        @Fetch
        @RelatedTo(direction=Direction.INCOMING)
        TestEntityOne test;

        TestEntityTwo() {
        }
    }

    @NodeEntity
    static class TestEntityOne {
        @GraphId
        Long id;
        @Fetch
        @RelatedTo
        TestEntityTwo test;

        TestEntityOne() {
        }
    }
}

