/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.annotation.relatedto;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.Direction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.annotation.EndNode;
import org.springframework.data.neo4j.annotation.Fetch;
import org.springframework.data.neo4j.annotation.GraphId;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.RelatedTo;
import org.springframework.data.neo4j.annotation.RelatedToVia;
import org.springframework.data.neo4j.annotation.RelationshipEntity;
import org.springframework.data.neo4j.annotation.StartNode;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:related-to-test-context.xml"})
@Transactional
public class BiDirectionalRelatedToViaWithCollectionFetchMappingTests {
    @Autowired
    Neo4jTemplate template;

    @Test
    public void testLoadBidirectionalRelationship() throws Exception {
        TestEntity parent = (TestEntity)this.template.save((Object)new TestEntity());
        TestEntity kid = (TestEntity)this.template.save((Object)new TestEntity());
        TestEntity kid2 = (TestEntity)this.template.save((Object)new TestEntity());
        TestRelationship rel1 = (TestRelationship)this.template.save((Object)new TestRelationship(parent, kid));
        TestRelationship rel2 = (TestRelationship)this.template.save((Object)new TestRelationship(parent, kid2));
        TestEntity aParent = (TestEntity)this.template.findOne(parent.id.longValue(), TestEntity.class);
        List<TestRelationship> kids = aParent.kids;
        Assert.assertEquals((long)2L, (long)kids.size());
        TestRelationship kidRel1 = kids.get(0);
        TestRelationship kidRel2 = kids.get(1);
        Assert.assertThat(Arrays.asList(kidRel1.id, kidRel2.id), (Matcher)Matchers.hasItems((Object[])new Long[]{rel1.id, rel2.id}));
        Assert.assertSame((Object)aParent, (Object)kidRel1.parent);
        Assert.assertSame((Object)aParent, (Object)kidRel2.parent);
        Assert.assertThat(Arrays.asList(kidRel1.kid.id, kidRel2.kid.id), (Matcher)Matchers.hasItems((Object[])new Long[]{kid.id, kid2.id}));
        Assert.assertThat(aParent.directKids, (Matcher)Matchers.hasItems((Object[])new TestEntity[]{kidRel1.kid, kidRel2.kid}));
    }

    @RelationshipEntity(type="test")
    static class TestRelationship {
        @GraphId
        Long id;
        @Fetch
        @StartNode
        TestEntity parent;
        @Fetch
        @EndNode
        TestEntity kid;

        TestRelationship() {
        }

        public TestRelationship(TestEntity parent, TestEntity kid) {
            this.parent = parent;
            this.kid = kid;
        }
    }

    @NodeEntity
    static class TestEntity {
        @GraphId
        Long id;
        @Fetch
        @RelatedToVia(type="test")
        List<TestRelationship> kids;
        @Fetch
        @RelatedTo(type="test")
        List<TestEntity> directKids;
        @RelatedToVia(type="test", direction=Direction.INCOMING)
        TestRelationship parent;

        TestEntity() {
        }
    }
}

