/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.annotation.relatedto;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.data.neo4j.annotation.IdentifiableEntity;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.RelatedTo;
import org.springframework.data.neo4j.annotation.relatedto.Course;

@NodeEntity
public class Student
extends IdentifiableEntity {
    private String name;
    @RelatedTo(type="attends")
    private Set<Course> favouriteCourses = new HashSet<Course>();
    @RelatedTo(type="attends", enforceTargetType=true)
    private Set<Course> dislikedCourses = new HashSet<Course>();

    public Student() {
    }

    public Student(String name) {
        this.name = name;
    }

    public void likes(Course ... courses) {
        this.favouriteCourses.addAll(Arrays.asList(courses));
    }

    public void isBoredWith(Course ... courses) {
        this.dislikedCourses.addAll(Arrays.asList(courses));
    }

    public Set<Course> getFavouriteCourses() {
        return this.favouriteCourses;
    }

    public Set<Course> getDislikedCourses() {
        return this.dislikedCourses;
    }
}

