/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.neo4j.config.TestEntity;
import org.springframework.data.neo4j.model.PersonRepository;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.support.mapping.Neo4jPersistentEntityImpl;
import org.springframework.transaction.PlatformTransactionManager;

public class DataGraphNamespaceHandlerTests {
    @Test
    public void injectionForJustStoreDir() {
        Config config = this.assertInjected("");
        Assert.assertNotNull((Object)config.personRepository);
    }

    @Test
    public void injectionForExistingGraphDatabaseService() {
        Config config = this.assertInjected("-external-embedded");
        GraphDatabaseAPI gds = (GraphDatabaseAPI)config.graphDatabaseService;
        Assert.assertEquals(EmbeddedGraphDatabase.class, gds.getClass());
        org.neo4j.kernel.configuration.Config neoConfig = gds.getKernelData().getConfig();
        Assert.assertEquals((Object)"true", neoConfig.getParams().get("allow_store_upgrade"));
    }

    @Test
    @Ignore(value="todo setup zk-cluster")
    public void injectionForExistingHighlyAvailableGraphDatabaseService() {
        Config config = this.assertInjected("-external-ha");
        AbstractGraphDatabase gds = (AbstractGraphDatabase)config.graphDatabaseService;
        org.neo4j.kernel.configuration.Config neoConfig = gds.getKernelData().getConfig();
        Assert.assertEquals((Object)"HighlyAvailableGraphDatabase", (Object)gds.getClass().getSimpleName());
        Assert.assertEquals((Object)"1", neoConfig.getParams().get("ha.server_id"));
    }

    @Test
    public void injectionForCodeConfiguredExistingGraphDatabaseService() {
        this.assertInjected("-code");
    }

    @Test
    public void injectionForBasePackageOfEntities() {
        Config config = this.assertInjected("-entities");
        Collection entities = config.mappingContext.getPersistentEntities();
        Assert.assertTrue((entities.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals(TestEntity.class, (Object)((Neo4jPersistentEntityImpl)entities.iterator().next()).getType());
    }

    @Test
    public void injectionForConversionService() {
        Config config = this.assertInjected("-conversion");
        ConversionService conversionService = config.neo4jTemplate.getConversionService();
        Assert.assertEquals((Object)true, (Object)conversionService.canConvert(Enum.class, String.class));
        Assert.assertEquals((Object)true, (Object)conversionService.canConvert(Config.class, Integer.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Config assertInjected(String testCase) {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("classpath:org/springframework/data/neo4j/config/DataGraphNamespaceHandlerTests" + testCase + "-context.xml");
        try {
            Config config = (Config)ctx.getBean("config", Config.class);
            Neo4jTemplate template = config.neo4jTemplate;
            Assert.assertNotNull((String)"template", (Object)template);
            AbstractGraphDatabase graphDatabaseService = (AbstractGraphDatabase)template.getGraphDatabaseService();
            File directory = new File("target", "config-test");
            Assert.assertEquals((String)"store-dir", (Object)directory.getAbsolutePath(), (Object)graphDatabaseService.getStoreDir());
            Assert.assertNotNull((String)"graphDatabaseService", (Object)config.graphDatabaseService);
            Assert.assertNotNull((String)"transactionManager", (Object)config.transactionManager);
            config.graphDatabaseService.shutdown();
            Config config2 = config;
            return config2;
        }
        finally {
            ctx.close();
        }
    }

    public static class TestConverter
    implements GenericConverter {
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(new GenericConverter.ConvertiblePair(Config.class, Integer.class));
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            return source.hashCode();
        }
    }

    static class Config {
        @Autowired
        GraphDatabaseService graphDatabaseService;
        @Autowired
        Neo4jTemplate neo4jTemplate;
        @Autowired
        PlatformTransactionManager transactionManager;
        @Autowired(required=false)
        Neo4jMappingContext mappingContext;
        @Autowired(required=false)
        PersonRepository personRepository;

        Config() {
        }
    }
}

