/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.inheritance;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.inheritance.model.Project;
import org.springframework.data.neo4j.inheritance.model.ProjectDetail;
import org.springframework.data.neo4j.inheritance.model.ProjectDetailRelationship;
import org.springframework.data.neo4j.inheritance.repository.ProjectDetailRepository;
import org.springframework.data.neo4j.inheritance.repository.ProjectRepository;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
public class InheritanceTests {
    private String validName = "projectDetail";
    @Autowired
    ProjectRepository projectRepository;
    @Autowired
    ProjectDetailRepository projectDetailRepository;
    @Autowired
    Neo4jTemplate template;

    @Test
    @Transactional
    public void testCreatedProjectWithInheritance() throws Exception {
        Project project = new Project();
        project = (Project)this.projectRepository.save(project);
        ProjectDetail projectDetail = new ProjectDetail(this.validName);
        this.projectDetailRepository.save(projectDetail);
        ProjectDetailRelationship projectDetailRelationship = new ProjectDetailRelationship(null, project, projectDetail);
        this.template.save((Object)projectDetailRelationship);
        project.getProjectDetailRelationships().add(projectDetailRelationship);
        project = (Project)this.projectRepository.save(project);
        Assert.assertEquals((long)1L, (long)IteratorUtil.count((Iterable)this.projectRepository.findAll()));
        Assert.assertEquals((long)1L, (long)IteratorUtil.count((Iterable)this.projectDetailRepository.findAll()));
        ProjectDetail actualProjectDetail = (ProjectDetail)this.projectDetailRepository.findAll().iterator().next();
        Assert.assertEquals((Object)this.validName, (Object)actualProjectDetail.getName());
        Assert.assertEquals((Object)project.getEntityId(), (Object)actualProjectDetail.getParentProject().getEntityId());
        Project actualProject = (Project)this.projectRepository.findOne(project.getEntityId());
        Assert.assertEquals((long)1L, (long)actualProject.getProjectDetailRelationships().size());
    }
}

