/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.lifecycle;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.config.EnableNeo4jRepositories;
import org.springframework.data.neo4j.config.Neo4jConfiguration;
import org.springframework.data.neo4j.lifecycle.AfterSaveEvent;
import org.springframework.data.neo4j.lifecycle.Bar;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
@Transactional
public class AfterSaveEventTests {
    @Autowired
    private Neo4jTemplate template;

    @Test
    public void shouldFireAfterEntityIsSaved() throws Exception {
        Bar entity = new Bar();
        Assert.assertThat((Object)((Bar)this.template.save((Object)entity)).generatedId, (Matcher)CoreMatchers.is((Object)"no event"));
        Assert.assertThat((Object)entity.generatedId, (Matcher)CoreMatchers.is((Object)"after event"));
        Assert.assertThat((Object)((Bar)IteratorUtil.single((Iterable)this.template.findAll(Bar.class))).generatedId, (Matcher)CoreMatchers.is((Object)"no event"));
    }

    @Configuration
    @EnableNeo4jRepositories
    static class TestConfig
    extends Neo4jConfiguration {
        TestConfig() {
        }

        @Bean
        GraphDatabaseService graphDatabaseService() {
            return new ImpermanentGraphDatabase();
        }

        @Bean
        ApplicationListener<AfterSaveEvent> beforeSaveEventApplicationListener() {
            return new ApplicationListener<AfterSaveEvent>(){

                public void onApplicationEvent(AfterSaveEvent event) {
                    Bar bar = (Bar)event.getEntity();
                    bar.generatedId = "after event";
                }
            };
        }
    }
}

