/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.lifecycle;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.MappingContextIsNewStrategyFactory;
import org.springframework.data.neo4j.annotation.GraphId;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.lifecycle.AuditingEventListener;
import org.springframework.data.neo4j.lifecycle.BeforeSaveEvent;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.support.IsNewStrategyFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class AuditingEventListenerUnitTests {
    IsNewAwareAuditingHandler<Object> handler;
    IsNewStrategyFactory factory;
    AuditingEventListener listener;

    @Before
    public void setUp() {
        Neo4jMappingContext mappingContext = new Neo4jMappingContext();
        this.factory = new MappingContextIsNewStrategyFactory((MappingContext)mappingContext);
        this.handler = (IsNewAwareAuditingHandler)Mockito.spy((Object)new IsNewAwareAuditingHandler(this.factory));
        ((IsNewAwareAuditingHandler)Mockito.doNothing().when(this.handler)).markCreated(Mockito.any(Object.class));
        ((IsNewAwareAuditingHandler)Mockito.doNothing().when(this.handler)).markModified(Mockito.any(Object.class));
        this.listener = new AuditingEventListener(this.handler);
    }

    @Test(expected=IllegalArgumentException.class)
    public void rejectsNullAuditingHandler() {
        new AuditingEventListener(null);
    }

    @Test
    public void triggersCreationMarkForObjectWithEmptyId() {
        Sample sample = new Sample();
        this.listener.onApplicationEvent(new BeforeSaveEvent((Object)this, (Object)sample));
        ((IsNewAwareAuditingHandler)Mockito.verify(this.handler, (VerificationMode)Mockito.times((int)1))).markCreated((Object)sample);
        ((IsNewAwareAuditingHandler)Mockito.verify(this.handler, (VerificationMode)Mockito.times((int)0))).markModified(Mockito.any(Sample.class));
    }

    @Test
    public void triggersModificationMarkForObjectWithSetId() {
        Sample sample = new Sample();
        sample.id = "id";
        this.listener.onApplicationEvent(new BeforeSaveEvent((Object)this, (Object)sample));
        ((IsNewAwareAuditingHandler)Mockito.verify(this.handler, (VerificationMode)Mockito.times((int)0))).markCreated(Mockito.any(Sample.class));
        ((IsNewAwareAuditingHandler)Mockito.verify(this.handler, (VerificationMode)Mockito.times((int)1))).markModified((Object)sample);
    }

    @NodeEntity
    static class Sample {
        @GraphId
        String id;

        Sample() {
        }
    }
}

