/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.lifecycle;

import java.util.LinkedList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.SetHelper;
import org.springframework.data.neo4j.config.EnableNeo4jRepositories;
import org.springframework.data.neo4j.config.Neo4jConfiguration;
import org.springframework.data.neo4j.lifecycle.BeforeSaveEvent;
import org.springframework.data.neo4j.lifecycle.Child;
import org.springframework.data.neo4j.lifecycle.FictionalCharacter;
import org.springframework.data.neo4j.lifecycle.Parent;
import org.springframework.data.neo4j.lifecycle.Slaying;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.node.Neo4jHelper;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
@Transactional
public class SaveEventTests {
    @Autowired
    Neo4jTemplate template;
    static final LinkedList<Object> entities = new LinkedList();

    @BeforeTransaction
    public void beforeTransaction() {
        Neo4jHelper.cleanDb((Neo4jTemplate)this.template);
    }

    @Before
    public void before() {
        entities.clear();
    }

    @Test
    public void shouldFireEventForNodeEntity() throws Exception {
        Child child = new Child();
        this.template.save((Object)child);
        Assert.assertThat((Object)entities.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)((Child)entities.get(0)), (Matcher)Matchers.is((Object)child));
    }

    @Test
    public void shouldFireEventForRelationshipEntity() throws Exception {
        FictionalCharacter fingolfin = (FictionalCharacter)this.template.save((Object)new FictionalCharacter("Fingolfin"));
        FictionalCharacter morgoth = (FictionalCharacter)this.template.save((Object)new FictionalCharacter("Morgoth"));
        entities.clear();
        Slaying slaying = new Slaying(morgoth, fingolfin, "Dagor Bragollach");
        this.template.save((Object)slaying);
        Assert.assertThat((Object)entities.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)((Slaying)SaveEventTests.entities.get((int)0)).battle, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Dagor Bragollach")));
    }

    @Test
    public void shouldFireEventForNodeEntities() throws Exception {
        Child child1 = new Child("Huey");
        Child child2 = new Child("Louie");
        Child child3 = new Child("Dewey");
        Parent parent = new Parent(SetHelper.asSet(child1, child2, child3));
        this.template.save((Object)parent);
        Assert.assertThat((Object)entities.size(), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)((Parent)entities.get(0)), (Matcher)Matchers.is((Object)parent));
        Assert.assertThat((Object)((Child)entities.get(1)), (Matcher)Matchers.is((Object)child1));
        Assert.assertThat((Object)((Child)entities.get(2)), (Matcher)Matchers.is((Object)child2));
        Assert.assertThat((Object)((Child)entities.get(3)), (Matcher)Matchers.is((Object)child3));
    }

    @Test
    public void shouldFireEventForRelationshipEntities() throws Exception {
        FictionalCharacter beleg = (FictionalCharacter)this.template.save((Object)new FictionalCharacter("Beleg"));
        FictionalCharacter brandir = (FictionalCharacter)this.template.save((Object)new FictionalCharacter("Brandir"));
        entities.clear();
        FictionalCharacter turin = new FictionalCharacter("T\u00farin");
        turin.slew(beleg, brandir);
        this.template.save((Object)turin);
        Assert.assertThat((Object)entities.size(), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)((FictionalCharacter)SaveEventTests.entities.get((int)0)).id, (Matcher)Matchers.is((Object)turin.id));
        Assert.assertThat((Object)((Slaying)SaveEventTests.entities.get((int)1)).slayee.id, (Matcher)Matchers.is((Matcher)Matchers.either((Matcher)Matchers.equalTo((Object)beleg.id)).or(Matchers.equalTo((Object)brandir.id))));
        Assert.assertThat((Object)((Slaying)SaveEventTests.entities.get((int)2)).slayee.id, (Matcher)Matchers.is((Matcher)Matchers.either((Matcher)Matchers.equalTo((Object)beleg.id)).or(Matchers.equalTo((Object)brandir.id))));
    }

    @Test
    public void shouldFireEventForNodeEntityWhenItIsSavedIndirectly() throws Exception {
        Child child = new Child();
        Parent parent = new Parent(child);
        this.template.save((Object)parent);
        Assert.assertThat((Object)entities.size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)((Parent)entities.get(0)), (Matcher)Matchers.is((Object)parent));
        Assert.assertThat((Object)((Child)entities.get(1)), (Matcher)Matchers.is((Object)child));
    }

    @Test
    public void shouldFireEventForRelationshipEntityWhenItIsSavedIndirectly() throws Exception {
        FictionalCharacter fingolfin = (FictionalCharacter)this.template.save((Object)new FictionalCharacter("Fingolfin"));
        entities.clear();
        FictionalCharacter morgoth = new FictionalCharacter("Morgoth");
        morgoth.slew(fingolfin, "Dagor Bragollach");
        this.template.save((Object)morgoth);
        Assert.assertThat((Object)entities.size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)((FictionalCharacter)SaveEventTests.entities.get((int)0)).id, (Matcher)Matchers.is((Object)morgoth.id));
        Assert.assertThat((Object)((Slaying)SaveEventTests.entities.get((int)1)).battle, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Dagor Bragollach")));
    }

    @Test
    public void shouldFireEventForUpdatedEntities() throws Exception {
        Parent parent = (Parent)this.template.save((Object)new Parent("Donald Duck"));
        entities.clear();
        parent = (Parent)this.template.findOne(parent.id.longValue(), Parent.class);
        parent.name = "Mickey Mouse";
        this.template.save((Object)parent);
        Assert.assertThat((Object)entities.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)((Parent)entities.get(0)), (Matcher)Matchers.is((Object)parent));
    }

    @Test
    public void shouldFireEventEvenIfEntityHasNotBeenUpdated() throws Exception {
        Parent parent = (Parent)this.template.save((Object)new Parent("Uncle Scrooge"));
        entities.clear();
        parent = (Parent)this.template.findOne(parent.id.longValue(), Parent.class);
        this.template.save((Object)parent);
        Assert.assertThat((Object)entities.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)((Parent)entities.get(0)), (Matcher)Matchers.is((Object)parent));
    }

    @Test
    public void shouldNotFireEventForUpdatedRelatedEntities() throws Exception {
        Parent parent = (Parent)this.template.save((Object)new Parent(new Child("Daisy Duck")));
        entities.clear();
        parent = (Parent)this.template.findOne(parent.id.longValue(), Parent.class);
        parent.eldest.name = "Minnie Mouse";
        this.template.save((Object)parent);
        Assert.assertThat((Object)entities.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)((Parent)entities.get(0)), (Matcher)Matchers.is((Object)parent));
    }

    @Configuration
    @EnableNeo4jRepositories
    static class TestConfig
    extends Neo4jConfiguration {
        TestConfig() {
        }

        @Bean
        GraphDatabaseService graphDatabaseService() {
            return new ImpermanentGraphDatabase();
        }

        @Bean
        ApplicationListener<BeforeSaveEvent> beforeSaveEventApplicationListener() {
            return new ApplicationListener<BeforeSaveEvent>(){

                public void onApplicationEvent(BeforeSaveEvent event) {
                    entities.add(event.getEntity());
                }
            };
        }
    }
}

