/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.mapping;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.springframework.data.neo4j.mapping.ManagedEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentTestBase;
import org.springframework.data.neo4j.model.Friendship;
import org.springframework.data.neo4j.model.Person;
import org.springframework.transaction.annotation.Transactional;

public class Neo4jEntityPersisterTests
extends Neo4jPersistentTestBase {
    @Test
    public void testCreateEntityFromStoredType() throws Exception {
        Node personNode = this.template.createNode();
        personNode.setProperty("name", (Object)"Michael");
        Person person = (Person)this.entityPersister.createEntityFromState((PropertyContainer)personNode, Person.class, this.template.getMappingPolicy(Person.class), this.template);
        Assert.assertEquals((Object)"Michael", (Object)person.getName());
    }

    @Test
    public void testCreateEntityFromState() throws Exception {
    }

    @Test
    public void testProjectTo() throws Exception {
        this.storeInGraph(this.michael);
        Neo4jPersistentTestBase.Developer developer = (Neo4jPersistentTestBase.Developer)this.entityPersister.projectTo((Object)this.michael, Neo4jPersistentTestBase.Developer.class, this.template);
        Assert.assertEquals((Object)this.michael.getId(), (Object)developer.id);
        Assert.assertEquals((Object)this.michael.getName(), (Object)developer.name);
    }

    @Test
    public void testGetPersistentState() throws Exception {
        this.storeInGraph(this.michael);
        Assert.assertEquals((Object)this.michaelNode(), (Object)this.entityPersister.getPersistentState((Object)this.michael));
    }

    @Test
    public void testPersist() throws Exception {
        this.entityPersister.persist((Object)this.michael, this.template.getMappingPolicy((Object)this.michael), this.template, null);
        Assert.assertEquals((Object)this.michaelNode().getId(), (Object)this.michael.getId());
        Assert.assertEquals((Object)this.michaelNode(), (Object)this.entityPersister.getPersistentState((Object)this.michael));
        Assert.assertEquals((Object)this.michaelNode().getProperty("name"), (Object)this.michael.getName());
    }

    @Test
    public void testIsManaged() throws Exception {
        Assert.assertEquals((Object)false, (Object)this.entityPersister.isManaged((Object)this.michael));
        Assert.assertEquals((Object)true, (Object)this.entityPersister.isManaged(Mockito.mock(ManagedEntity.class)));
    }

    @Test
    public void testIsNodeEntity() throws Exception {
        Assert.assertEquals((Object)true, (Object)this.entityPersister.isNodeEntity(Person.class));
        Assert.assertEquals((Object)false, (Object)this.entityPersister.isNodeEntity(Friendship.class));
    }

    @Test
    public void testIsRelationshipEntity() throws Exception {
        Assert.assertEquals((Object)false, (Object)this.entityPersister.isRelationshipEntity(Person.class));
        Assert.assertEquals((Object)true, (Object)this.entityPersister.isRelationshipEntity(Friendship.class));
    }

    @Test
    @Transactional
    public void testFetchSingleEntity() {
        Node node = this.template.getReferenceNode();
        node.setProperty("name", (Object)"Fetch");
        Person p = new Person(node.getId());
        this.template.fetch((Object)p);
        Assert.assertEquals((Object)"Fetch", (Object)p.getName());
    }

    @Test
    @Transactional
    public void testFetchEntityCollection() {
        Node node = this.template.getReferenceNode();
        node.setProperty("name", (Object)"Fetch");
        Person p = new Person(node.getId());
        this.template.fetch(Arrays.asList(p));
        Assert.assertEquals((Object)"Fetch", (Object)p.getName());
    }
}

