/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.mapping;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.model.PrimitiveIdEntity;
import org.springframework.data.neo4j.support.index.IndexType;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.support.mapping.Neo4jPersistentEntityImpl;

public class Neo4jMappingContextTests {
    private Neo4jMappingContext mappingContext;
    private Neo4jPersistentEntityImpl<?> personType;

    @Before
    public void setUp() throws Exception {
        this.mappingContext = new Neo4jMappingContext();
        this.personType = (Neo4jPersistentEntityImpl)this.mappingContext.getPersistentEntity(Person.class);
    }

    @Test
    public void checkGraphIdProperty() {
        Neo4jPersistentProperty idProperty = (Neo4jPersistentProperty)this.personType.getIdProperty();
        Assert.assertEquals((Object)"graphId", (Object)idProperty.getName());
    }

    @Test
    public void checkNameProperty() {
        Neo4jPersistentProperty nameProperty = (Neo4jPersistentProperty)this.personType.getPersistentProperty("name");
        Assert.assertEquals((Object)"name", (Object)nameProperty.getName());
        Assert.assertEquals(String.class, (Object)nameProperty.getType());
        Assert.assertEquals((Object)true, (Object)nameProperty.isIndexed());
        Assert.assertEquals((Object)"name-index", (Object)nameProperty.getIndexInfo().getIndexName());
        Assert.assertEquals((Object)IndexType.SIMPLE, (Object)nameProperty.getIndexInfo().getIndexType());
        Assert.assertEquals((Object)false, (Object)nameProperty.isRelationship());
    }

    @Test(expected=MappingException.class)
    public void testPrimitiveGraphIdFails() {
        this.mappingContext.getPersistentEntity(PrimitiveIdEntity.class);
    }
}

