/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.mapping;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.data.neo4j.model.Being;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.support.mapping.Neo4jPersistentEntityImpl;
import org.springframework.data.neo4j.support.mapping.StoredEntityType;

public class Neo4jPersistentEntityTests {
    private Neo4jMappingContext mappingContext;
    private Neo4jPersistentEntityImpl<?> personType;

    @Before
    public void setUp() throws Exception {
        this.mappingContext = new Neo4jMappingContext();
        this.personType = (Neo4jPersistentEntityImpl)this.mappingContext.getPersistentEntity(Person.class);
    }

    @Test
    public void testDirectEntityType() {
        StoredEntityType entityType = this.personType.getEntityType();
        Assert.assertEquals((Object)"Person", (Object)entityType.getAlias());
        Assert.assertEquals(Person.class, (Object)entityType.getType());
        Assert.assertEquals((long)1L, (long)entityType.getSuperTypes().size());
        StoredEntityType superType = (StoredEntityType)IteratorUtil.single((Iterable)entityType.getSuperTypes());
        Assert.assertEquals(Being.class, (Object)superType.getType());
        Assert.assertEquals((Object)"Being", (Object)superType.getAlias());
        Assert.assertEquals((long)0L, (long)superType.getSuperTypes().size());
    }
}

