/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.model;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.springframework.data.neo4j.annotation.Fetch;
import org.springframework.data.neo4j.annotation.GraphId;
import org.springframework.data.neo4j.annotation.Indexed;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.annotation.RelatedTo;
import org.springframework.data.neo4j.annotation.RelatedToVia;
import org.springframework.data.neo4j.fieldaccess.DynamicProperties;
import org.springframework.data.neo4j.model.Being;
import org.springframework.data.neo4j.model.BestFriend;
import org.springframework.data.neo4j.model.Car;
import org.springframework.data.neo4j.model.Friendship;
import org.springframework.data.neo4j.model.Group;
import org.springframework.data.neo4j.model.IGroup;
import org.springframework.data.neo4j.model.Personality;
import org.springframework.data.neo4j.model.RootEntity;
import org.springframework.data.neo4j.support.index.IndexType;

@NodeEntity
public class Person
implements Being {
    public static final String NAME_INDEX = "name-index";
    public static final RelationshipType KNOWS = DynamicRelationshipType.withName((String)"knows");
    @GraphId
    private Long graphId;
    @Indexed(indexName="name-index")
    @Size(min=3, max=20)
    private String name;
    @Indexed
    private String nickname;
    @Indexed(indexType=IndexType.POINT, indexName="personLayer")
    private String wkt;
    @Max(value=100L)
    @Min(value=0L)
    @Indexed
    private int age;
    private Object dynamicProperty;
    private Short height;
    private transient String thought;
    private Personality personality;
    private Date birthdate;
    private Person spouse;
    private Car car;
    private DynamicProperties personalProperties;
    @RelatedTo
    private Person mother;
    @RelatedTo(type="boss", direction=Direction.INCOMING)
    private Person boss;
    @RelatedToVia
    private BestFriend bestFriend;
    @Fetch
    @RelatedToVia(type="knows", elementClass=Friendship.class)
    private Iterable<Friendship> friendships;
    @Query(value="start person=node({self}) match (person)<-[?:boss]-(boss) return boss")
    private Person bossByQuery;
    @Query(value="start person=node({self}) match (person)<-[?:boss]-(boss) return boss.name")
    private String bossName;
    @Query(value="start person=node({self}) match (person)<-[:persons]-(team)-[:persons]->(member) return member")
    private Iterable<Person> otherTeamMembers;
    @Query(value="start person=node({self}) match (person)<-[:persons]-(team)-[:persons]->(member) return member.name?, member.age?")
    private Iterable<Map<String, Object>> otherTeamMemberData;
    @RelatedTo(elementClass=Group.class, type="interface_test", direction=Direction.OUTGOING)
    private Set<IGroup> groups;
    RootEntity root;

    public RootEntity getRoot() {
        return this.root;
    }

    public void setRoot(RootEntity root) {
        this.root = root;
    }

    public Set<IGroup> getGroups() {
        return this.groups;
    }

    public Person(Node n) {
        this.graphId = n.getId();
    }

    public String getBossName() {
        return this.bossName;
    }

    public Iterable<Person> getOtherTeamMembers() {
        return this.otherTeamMembers;
    }

    public Iterable<Map<String, Object>> getOtherTeamMemberData() {
        return this.otherTeamMemberData;
    }

    public Person getBossByQuery() {
        return this.bossByQuery;
    }

    public Person() {
    }

    public Person(String name, int age) {
        this.name = name;
        this.age = age;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public Short getHeight() {
        return this.height;
    }

    public void setHeight(Short height) {
        this.height = height;
    }

    public Person getSpouse() {
        return this.spouse;
    }

    public void setSpouse(Person spouse) {
        this.spouse = spouse;
    }

    public Person getMother() {
        return this.mother;
    }

    public void setMother(Person mother) {
        this.mother = mother;
    }

    public Person getBoss() {
        return this.boss;
    }

    public void setBoss(Person boss) {
        this.boss = boss;
    }

    public void setLocation(String locationInWkt) {
        this.wkt = locationInWkt;
    }

    public void setLocation(double lon, double lat) {
        this.wkt = "POINT ( " + lon + " " + lat + " )";
    }

    public String toString() {
        return "[" + this.graphId + "] " + this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Person person = (Person)o;
        if (this.graphId == null) {
            return super.equals(o);
        }
        return this.graphId.equals(person.graphId);
    }

    public int hashCode() {
        return this.graphId != null ? this.graphId.hashCode() : super.hashCode();
    }

    public Iterable<Friendship> getFriendships() {
        return this.friendships;
    }

    public void setFriendships(Iterable<Friendship> f) {
        this.friendships = f;
    }

    public Friendship knows(Person p) {
        return new Friendship(this, p, "knows");
    }

    public void setPersonality(Personality personality) {
        this.personality = personality;
    }

    public Personality getPersonality() {
        return this.personality;
    }

    public void setThought(String thought) {
        this.thought = thought;
    }

    public String getThought() {
        return this.thought;
    }

    public Date getBirthdate() {
        return this.birthdate;
    }

    public void setBirthdate(Date birthdate) {
        this.birthdate = birthdate;
    }

    public Long getId() {
        return this.graphId;
    }

    public void setCar(Car car) {
        this.car = car;
    }

    public Car getCar() {
        return this.car;
    }

    public void setProperty(String key, Object value) {
        this.personalProperties.setProperty(key, value);
    }

    public Object getProperty(String key) {
        return this.personalProperties.getProperty(key);
    }

    public DynamicProperties getPersonalProperties() {
        return this.personalProperties;
    }

    public void setPersonalProperties(DynamicProperties personalProperties) {
        this.personalProperties = personalProperties;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public void setDynamicProperty(Object dynamicProperty) {
        this.dynamicProperty = dynamicProperty;
    }

    public Object getDynamicProperty() {
        return this.dynamicProperty;
    }

    public Person(Long graphId) {
        this.graphId = graphId;
    }

    public void setBestFriend(Person p2, String secret) {
        this.bestFriend = p2 == null ? null : new BestFriend(this, p2, secret);
    }

    public BestFriend getBestFriend() {
        return this.bestFriend;
    }
}

