/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.conversion.EndResult;
import org.springframework.data.neo4j.model.Car;
import org.springframework.data.neo4j.model.Friendship;
import org.springframework.data.neo4j.model.Group;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.model.Personality;
import org.springframework.data.neo4j.model.RootEntity;
import org.springframework.data.neo4j.model.User;
import org.springframework.data.neo4j.repository.BeingRepository;
import org.springframework.data.neo4j.repository.FriendshipRepository;
import org.springframework.data.neo4j.repository.GroupRepository;
import org.springframework.data.neo4j.repository.MemberData;
import org.springframework.data.neo4j.repository.PersonRepository;
import org.springframework.data.neo4j.repository.TestTeam;
import org.springframework.data.neo4j.repository.UserRepository;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.conversion.NoSuchColumnFoundException;
import org.springframework.data.neo4j.support.node.Neo4jHelper;
import org.springframework.test.context.CleanContextCacheTestExecutionListener;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
@TestExecutionListeners(value={CleanContextCacheTestExecutionListener.class, DependencyInjectionTestExecutionListener.class, TransactionalTestExecutionListener.class})
public class GraphRepositoryTests {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private Neo4jTemplate neo4jTemplate;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private PersonRepository personRepository;
    @Autowired
    private BeingRepository beingRepository;
    @Autowired
    GroupRepository groupRepository;
    @Autowired
    FriendshipRepository friendshipRepository;
    private TestTeam testTeam;
    @Autowired
    Neo4jTemplate template;
    @Autowired
    UserRepository userRepository;
    @Autowired
    GraphDatabaseService gdb;

    @BeforeTransaction
    public void cleanDb() {
        Neo4jHelper.cleanDb((Neo4jTemplate)this.neo4jTemplate);
    }

    @Before
    public void setUp() throws Exception {
        this.testTeam = new TestTeam();
        this.testTeam.createSDGTeam(this.personRepository, this.groupRepository, this.friendshipRepository);
    }

    @Test
    public void deleteAll() {
        Assert.assertThat((Object)this.personRepository.count(), (Matcher)Matchers.is((Object)3L));
        new TransactionTemplate(this.transactionManager).execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                GraphRepositoryTests.this.personRepository.deleteAll();
            }
        });
        Assert.assertThat((Object)this.personRepository.count(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void deleteCollection() {
        Assert.assertThat((Object)this.personRepository.count(), (Matcher)Matchers.is((Object)3L));
        new TransactionTemplate(this.transactionManager).execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                GraphRepositoryTests.this.personRepository.delete(Arrays.asList(((GraphRepositoryTests)GraphRepositoryTests.this).testTeam.michael, ((GraphRepositoryTests)GraphRepositoryTests.this).testTeam.david));
            }
        });
        Assert.assertThat((Object)this.personRepository.count(), (Matcher)Matchers.is((Object)1L));
    }

    @Test
    public void deleteById() {
        final Long id = this.testTeam.michael.getId();
        new TransactionTemplate(this.transactionManager).execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                GraphRepositoryTests.this.personRepository.delete(id);
            }
        });
        Assert.assertThat((Object)this.personRepository.exists(id), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void deleteSingle() {
        new TransactionTemplate(this.transactionManager).execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                GraphRepositoryTests.this.personRepository.delete(((GraphRepositoryTests)GraphRepositoryTests.this).testTeam.michael);
            }
        });
        Assert.assertThat((Object)this.personRepository.exists(this.testTeam.michael.getId()), (Matcher)Matchers.is((Object)false));
    }

    @Test
    @Transactional
    public void findAll() {
        EndResult allPersons = this.personRepository.findAll();
        Assert.assertThat((Object)IteratorUtil.asCollection((Iterable)allPersons), (Matcher)Matchers.hasItems((Object[])new Person[]{this.testTeam.michael, this.testTeam.david, this.testTeam.emil}));
    }

    @Test
    @Transactional
    public void findAllSortedAscending() {
        Sort sort = new Sort(Sort.Direction.ASC, new String[]{"name"});
        EndResult allPersons = this.personRepository.findAll(sort);
        Assert.assertEquals(Arrays.asList(this.testTeam.david, this.testTeam.emil, this.testTeam.michael), (Object)IteratorUtil.asCollection((Iterable)allPersons));
    }

    @Test
    @Ignore
    public void findAllSortedWithFunction() {
        Sort sort = new Sort(Sort.Direction.ASC, new String[]{"lower(name)"});
        EndResult allPersons = this.personRepository.findAll(sort);
        Assert.assertEquals(Arrays.asList(this.testTeam.david, this.testTeam.emil, this.testTeam.michael), (Object)IteratorUtil.asCollection((Iterable)allPersons));
    }

    @Test
    @Transactional
    public void findAllSortedDescending() {
        Sort sort = new Sort(Sort.Direction.DESC, new String[]{"name"});
        EndResult allPersons = this.personRepository.findAll(sort);
        Assert.assertEquals(Arrays.asList(this.testTeam.michael, this.testTeam.emil, this.testTeam.david), (Object)IteratorUtil.asCollection((Iterable)allPersons));
    }

    @Test
    @Transactional
    public void findAllPageableWithSortDescending() {
        Sort sort = new Sort(Sort.Direction.DESC, new String[]{"name"});
        PageRequest page1Request = new PageRequest(0, 1, sort);
        PageRequest page2Request = new PageRequest(1, 1, sort);
        PageRequest page3Request = new PageRequest(2, 1, sort);
        Page page1Result = this.personRepository.findAll((Pageable)page1Request);
        Page page2Result = this.personRepository.findAll((Pageable)page2Request);
        Page page3Result = this.personRepository.findAll((Pageable)page3Request);
        Assert.assertEquals(Arrays.asList(this.testTeam.michael), (Object)IteratorUtil.asCollection((Iterable)page1Result));
        Assert.assertEquals(Arrays.asList(this.testTeam.emil), (Object)IteratorUtil.asCollection((Iterable)page2Result));
        Assert.assertEquals(Arrays.asList(this.testTeam.david), (Object)IteratorUtil.asCollection((Iterable)page3Result));
    }

    @Test
    @Transactional
    public void testFindIterableOfPersonWithQueryAnnotation() {
        Iterable<Person> teamMembers = this.personRepository.findAllTeamMembers(this.testTeam.sdg);
        Assert.assertThat((Object)IteratorUtil.asCollection(teamMembers), (Matcher)Matchers.hasItems((Object[])new Person[]{this.testTeam.michael, this.testTeam.david, this.testTeam.emil}));
    }

    @Test
    @Transactional
    public void testFindIterableOfPersonWithQueryAnnotationSpatial() {
        EndResult teamMembers = this.personRepository.findWithinBoundingBox("personLayer", 55.0, 15.0, 57.0, 17.0);
        Assert.assertThat((Object)IteratorUtil.asCollection((Iterable)teamMembers), (Matcher)Matchers.hasItems((Object[])new Person[]{this.testTeam.michael, this.testTeam.david}));
    }

    @Test
    @Transactional
    public void testFindIterableOfPersonWithQueryAnnotationAndGremlin() {
        Iterable<Person> teamMembers = this.personRepository.findAllTeamMembersGremlin(this.testTeam.sdg);
        Assert.assertThat((Object)IteratorUtil.asCollection(teamMembers), (Matcher)Matchers.hasItems((Object[])new Person[]{this.testTeam.michael, this.testTeam.david, this.testTeam.emil}));
    }

    @Test
    @Transactional
    public void testFindPersonWithQueryAnnotation() {
        Person boss = this.personRepository.findBoss(this.testTeam.michael);
        Assert.assertThat((Object)boss, (Matcher)Matchers.is((Object)this.testTeam.emil));
    }

    @Test
    @Transactional
    public void testCypherQueryWithNoResultsReturnsNullForSingleType() {
        Person boss = this.personRepository.findBoss(this.testTeam.emil);
        Assert.assertThat((Object)boss, (Matcher)Matchers.is((Object)null));
    }

    @Test
    @Transactional
    public void testCypherQueryWithNoResultsReturnsNullForPage() {
        Page<Person> people = this.personRepository.findSubordinates(this.testTeam.michael, (Pageable)new PageRequest(0, 10));
        Assert.assertEquals((Object)true, (Object)people.getContent().isEmpty());
    }

    @Test
    @Transactional
    public void testCypherQueryForPage() {
        Page<Person> people = this.personRepository.findSubordinates(this.testTeam.emil, (Pageable)new PageRequest(0, 10));
        Assert.assertEquals((long)2L, (long)people.getContent().size());
        Assert.assertEquals((long)2L, (long)people.getTotalElements());
        Assert.assertEquals((long)1L, (long)people.getTotalPages());
    }

    @Test
    @Transactional
    public void testCypherQueryForPageWithCount() {
        Page<Person> people = this.personRepository.findSubordinatesWithCount(this.testTeam.emil, (Pageable)new PageRequest(0, 1));
        Assert.assertEquals((long)1L, (long)people.getContent().size());
        Assert.assertEquals((long)2L, (long)people.getTotalElements());
        Assert.assertEquals((long)2L, (long)people.getTotalPages());
    }

    @Test
    @Transactional
    public void testFindPersonWithQueryAnnotationUsingLongAsParameter() {
        Person boss = this.personRepository.findBoss(this.testTeam.michael.getId());
        Assert.assertThat((Object)boss, (Matcher)Matchers.is((Object)this.testTeam.emil));
    }

    @Test
    @Transactional
    public void shouldBeAbleToTurnQueryResultsToAMapResultInterface() throws Exception {
        MemberData first = this.personRepository.findMemberData(this.testTeam.michael).iterator().next();
        Assert.assertThat((Object)first.getBoss(), (Matcher)Matchers.is((Object)this.testTeam.emil));
        Assert.assertThat((Object)IteratorUtil.asCollection(first.getTeams()), (Matcher)Matchers.hasItem((Object)this.testTeam.sdg));
    }

    @Test
    @Transactional
    public void testFindIterableMapsWithQueryAnnotation() {
        Iterable<Map<String, Object>> teamMembers = this.personRepository.findAllTeamMemberData(this.testTeam.sdg);
        Assert.assertThat((Object)IteratorUtil.asCollection(teamMembers), (Matcher)Matchers.hasItems((Object[])new Map[]{this.testTeam.simpleRowFor(this.testTeam.michael, "member"), this.testTeam.simpleRowFor(this.testTeam.david, "member"), this.testTeam.simpleRowFor(this.testTeam.emil, "member")}));
    }

    @Test
    @Transactional
    public void testFindWithMultipleParameters() {
        boolean depth = true;
        int limit = 2;
        Iterable<Person> teamMembers = this.personRepository.findSomeTeamMembers(this.testTeam.sdg.getName(), 0, 2, 1);
        Assert.assertThat((Object)IteratorUtil.asCollection(teamMembers), (Matcher)Matchers.hasItems((Object[])new Person[]{this.testTeam.david, this.testTeam.emil}));
    }

    @Test
    @Transactional
    public void testFindPaged() {
        PageRequest page = new PageRequest(0, 1, Sort.Direction.ASC, new String[]{"member.name", "member.age"});
        Page<Person> teamMemberPage1 = this.personRepository.findAllTeamMembersPaged(this.testTeam.sdg, (Pageable)page);
        Assert.assertThat(teamMemberPage1, (Matcher)Matchers.hasItem((Object)this.testTeam.david));
    }

    @Test
    @Transactional
    public void testFindPagedDescending() {
        PageRequest page = new PageRequest(0, 2, Sort.Direction.DESC, new String[]{"member.name"});
        Page<Person> teamMemberPage1 = this.personRepository.findAllTeamMembersPaged(this.testTeam.sdg, (Pageable)page);
        Assert.assertEquals(Arrays.asList(this.testTeam.michael, this.testTeam.emil), (Object)IteratorUtil.asCollection(teamMemberPage1));
        Assert.assertThat((Object)teamMemberPage1.isFirstPage(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    @Transactional
    public void testFindPagedNull() {
        Page<Person> teamMemberPage1 = this.personRepository.findAllTeamMembersPaged(this.testTeam.sdg, null);
        Assert.assertEquals(new HashSet<Person>(Arrays.asList(this.testTeam.david, this.testTeam.emil, this.testTeam.michael)), (Object)IteratorUtil.addToCollection(teamMemberPage1, new HashSet()));
        Assert.assertThat((Object)teamMemberPage1.isFirstPage(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)teamMemberPage1.isLastPage(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    @Transactional
    public void testFindPagedEmptyResult() {
        Group group = (Group)this.neo4jTemplate.save((Object)new Group());
        Page<Person> result = this.personRepository.findAllTeamMembersPaged(group, (Pageable)new PageRequest(0, 10));
        Assert.assertThat((Object)result.isFirstPage(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)result.hasContent(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)result.hasNextPage(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)result.hasPreviousPage(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)result.isLastPage(), (Matcher)Matchers.is((Object)true));
        Assert.assertEquals((Object)true, (Object)result.getContent().isEmpty());
    }

    @Test
    @Transactional
    public void testFindSortedDescending() {
        Sort sort = new Sort(Sort.Direction.DESC, new String[]{"member.name"});
        Iterable<Person> teamMembers = this.personRepository.findAllTeamMembersSorted(this.testTeam.sdg, sort);
        Assert.assertEquals(Arrays.asList(this.testTeam.michael, this.testTeam.emil, this.testTeam.david), (Object)IteratorUtil.asCollection(teamMembers));
    }

    @Test
    @Transactional
    public void testGetStoredJavaType() {
        Person p = (Person)this.personRepository.save(new Person());
        Assert.assertEquals(Person.class, (Object)this.personRepository.getStoredJavaType(p));
        Assert.assertEquals(Person.class, (Object)this.personRepository.getStoredJavaType(this.neo4jTemplate.getPersistentState((Object)p)));
        Assert.assertEquals(null, (Object)this.personRepository.getStoredJavaType(new Person()));
    }

    @Test
    @Transactional
    public void testTemplateGetStoredJavaType() {
        Person p = (Person)this.neo4jTemplate.save((Object)new Person());
        Assert.assertEquals(Person.class, (Object)this.neo4jTemplate.getStoredJavaType((Object)p));
        Assert.assertEquals(Person.class, (Object)this.neo4jTemplate.getStoredJavaType((Object)this.neo4jTemplate.getPersistentState((Object)p)));
        Assert.assertEquals(null, (Object)this.neo4jTemplate.getStoredJavaType((Object)new Person()));
        Object alias = this.neo4jTemplate.getEntityType(Person.class).getAlias();
        Assert.assertEquals((Object)alias, (Object)this.neo4jTemplate.getStoredEntityType((Object)p).getAlias());
        Assert.assertEquals((Object)alias, (Object)this.neo4jTemplate.getStoredEntityType((Object)this.neo4jTemplate.getPersistentState((Object)p)).getAlias());
        Assert.assertEquals(null, (Object)this.neo4jTemplate.getStoredEntityType((Object)new Person()));
    }

    @Test
    @Transactional
    public void testTemplateGetStoredJavaTypeWithAlias() {
        Group g = (Group)this.neo4jTemplate.save((Object)new Group());
        Assert.assertEquals(Group.class, (Object)this.neo4jTemplate.getStoredJavaType((Object)g));
        Assert.assertEquals(Group.class, (Object)this.neo4jTemplate.getStoredJavaType((Object)this.neo4jTemplate.getPersistentState((Object)g)));
        Assert.assertEquals(null, (Object)this.neo4jTemplate.getStoredJavaType((Object)new Group()));
        Assert.assertEquals((Object)"g", (Object)this.neo4jTemplate.getStoredEntityType((Object)g).getAlias());
        Assert.assertEquals((Object)"g", (Object)this.neo4jTemplate.getStoredEntityType((Object)this.neo4jTemplate.getPersistentState((Object)g)).getAlias());
        Assert.assertEquals(null, (Object)this.neo4jTemplate.getStoredEntityType((Object)new Group()));
        Assert.assertEquals((Object)"g", (Object)this.neo4jTemplate.getEntityType(Group.class).getAlias());
    }

    @Test
    @Transactional
    public void testFindSortedNull() {
        Collection teamMembers = IteratorUtil.asCollection(this.personRepository.findAllTeamMembersSorted(this.testTeam.sdg, null));
        Assert.assertThat((Object)teamMembers, (Matcher)Matchers.hasItems((Object[])new Person[]{this.testTeam.michael, this.testTeam.emil, this.testTeam.david}));
    }

    @Test
    @Transactional
    public void testFindByNamedQuery() {
        Group team = this.personRepository.findTeam(this.testTeam.michael);
        Assert.assertThat((Object)team, (Matcher)Matchers.is((Object)this.testTeam.sdg));
    }

    @Test
    @Transactional
    public void findByName() {
        Iterable<Person> findByName = this.personRepository.findByName(this.testTeam.michael.getName());
        Assert.assertThat(findByName, (Matcher)Matchers.hasItem((Object)this.testTeam.michael));
    }

    @Test
    @Transactional
    public void findByPersonalityEnum() {
        this.testTeam.michael.setPersonality(Personality.EXTROVERT);
        this.neo4jTemplate.save((Object)this.testTeam.michael);
        Iterable<Person> result = this.personRepository.findByPersonality(Personality.EXTROVERT.name());
        Assert.assertThat(result, (Matcher)Matchers.hasItem((Object)this.testTeam.michael));
    }

    @Test(expected=NoSuchColumnFoundException.class)
    @Transactional
    public void missingColumnIsReportedNicely() {
        Iterable<MemberData> findByName = this.personRepository.nonWorkingQuery(this.testTeam.michael);
        Person boss = findByName.iterator().next().getBoss();
    }

    @Test
    @Transactional
    public void findByFullTextName() {
        this.testTeam.sdg.setFullTextName("test");
        this.neo4jTemplate.save((Object)this.testTeam.sdg);
        Iterable<Group> groups = this.groupRepository.findByFullTextNameLike("te*");
        Assert.assertThat(groups, (Matcher)Matchers.hasItem((Object)this.testTeam.sdg));
    }

    @Test
    @Transactional
    public void findPageByName() {
        Page<Group> groups = this.groupRepository.findByName(this.testTeam.sdg.getName(), (Pageable)new PageRequest(0, 1));
        Assert.assertThat(groups, (Matcher)Matchers.hasItem((Object)this.testTeam.sdg));
    }

    @Test
    @Transactional
    public void testCustomImplementation() {
        Friendship friendship = this.personRepository.befriend(this.testTeam.michael, this.testTeam.emil);
        Assert.assertNotNull((Object)friendship.getId());
        Person loaded = (Person)this.personRepository.findOne(this.testTeam.michael.getId());
        Assert.assertEquals((long)2L, (long)IteratorUtil.count(loaded.getFriendships()));
        Assert.assertThat(loaded.getFriendships(), (Matcher)Matchers.hasItem((Object)friendship));
    }

    @Test
    @Transactional
    public void testCreateDuplicateRelationship() {
        Assert.assertEquals((long)1L, (long)IteratorUtil.count((Iterable)((Node)this.neo4jTemplate.getPersistentState((Object)this.testTeam.michael)).getRelationships(new RelationshipType[]{Person.KNOWS})));
        this.personRepository.createDuplicateRelationshipBetween(this.testTeam.michael, this.testTeam.david, Friendship.class, "knows");
        Assert.assertEquals((long)2L, (long)IteratorUtil.count((Iterable)((Node)this.neo4jTemplate.getPersistentState((Object)this.testTeam.michael)).getRelationships(new RelationshipType[]{Person.KNOWS})));
    }

    @Test
    @Transactional
    public void testUseInterfaceInRelationships() {
        Person p = (Person)this.neo4jTemplate.save((Object)new Person());
        Group group = (Group)this.neo4jTemplate.save((Object)new Group());
        this.neo4jTemplate.createRelationshipBetween((Node)this.neo4jTemplate.getPersistentState((Object)p), (Node)this.neo4jTemplate.getPersistentState((Object)group), "interface_test", null);
        Person p2 = (Person)this.neo4jTemplate.fetch((Object)p);
        Assert.assertEquals((Object)group, (Object)IteratorUtil.firstOrNull(p2.getGroups()));
    }

    @Test
    @Transactional
    public void testConnectToRootEntity() {
        Node referenceNode = this.neo4jTemplate.getReferenceNode();
        this.neo4jTemplate.postEntityCreation((PropertyContainer)referenceNode, RootEntity.class);
        RootEntity root = (RootEntity)this.neo4jTemplate.findOne(referenceNode.getId(), RootEntity.class);
        root.setRootName("RootName");
        this.neo4jTemplate.save((Object)root);
        Assert.assertEquals((long)referenceNode.getId(), (long)root.getId());
        Assert.assertEquals((Object)"RootName", (Object)referenceNode.getProperty("rootName"));
        Assert.assertEquals((Object)"RootName", (Object)root.getRootName());
        Person person = new Person();
        person.setRoot(root);
        this.neo4jTemplate.save((Object)person);
        Person p2 = (Person)this.neo4jTemplate.findOne(person.getId().longValue(), Person.class);
        Assert.assertEquals((Object)root.getId(), (Object)p2.getRoot().getId());
    }

    @Test
    public void testUseInterfaceAsPersistentEntity() {
        List beings = (List)this.beingRepository.findAll().as(List.class);
        Assert.assertEquals((long)3L, (long)beings.size());
    }

    @Test
    @Transactional
    public void findWithMapResult() throws InterruptedException {
        Iterable<PersonRepository.NameAndPersonResult> result = this.personRepository.getAllNamesAndPeople();
        PersonRepository.NameAndPersonResult nameAndPerson = (PersonRepository.NameAndPersonResult)IteratorUtil.first(result);
        Assert.assertEquals((Object)this.testTeam.david.getName(), (Object)nameAndPerson.getName());
        Assert.assertEquals((Object)this.testTeam.david, (Object)nameAndPerson.getPerson());
    }

    @Test
    public void testFindMultiThreaded() throws Exception {
        final Car car = (Car)new TransactionTemplate(this.transactionManager).execute((TransactionCallback)new TransactionCallback<Car>(){

            public Car doInTransaction(TransactionStatus transactionStatus) {
                Car car = (Car)GraphRepositoryTests.this.template.save((Object)new Car());
                User user = (User)GraphRepositoryTests.this.template.save((Object)new User("foo").setCar(car));
                return car;
            }
        });
        ExecutorService pool = Executors.newFixedThreadPool(16);
        final AtomicInteger counter = new AtomicInteger();
        int count = 50;
        for (int i = 0; i < count; ++i) {
            pool.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        Car singleCar = (Car)GraphRepositoryTests.this.template.query("start user=node:User(name={name}) match user-[:Loves]->car return car limit 1", MapUtil.map((Object[])new Object[]{"name", "foo"})).to(Car.class).singleOrNull();
                        Assert.assertEquals((Object)singleCar.id, (Object)car.id);
                        counter.incrementAndGet();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)e.getMessage());
                    }
                }
            });
        }
        pool.shutdown();
        pool.awaitTermination(10L, TimeUnit.HOURS);
        Assert.assertEquals((long)count, (long)counter.get());
    }
}

