/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.annotation.MapResult;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.annotation.QueryType;
import org.springframework.data.neo4j.annotation.ResultColumn;
import org.springframework.data.neo4j.conversion.EndResult;
import org.springframework.data.neo4j.model.Group;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.repository.CypherDslRepository;
import org.springframework.data.neo4j.repository.GraphRepository;
import org.springframework.data.neo4j.repository.MemberData;
import org.springframework.data.neo4j.repository.NamedIndexRepository;
import org.springframework.data.neo4j.repository.PersonRepositoryFriendship;
import org.springframework.data.neo4j.repository.RelationshipOperationsRepository;
import org.springframework.data.neo4j.repository.SpatialRepository;
import org.springframework.data.repository.query.Param;

public interface PersonRepository
extends GraphRepository<Person>,
NamedIndexRepository<Person>,
SpatialRepository<Person>,
PersonRepositoryFriendship,
CypherDslRepository<Person>,
RelationshipOperationsRepository<Person> {
    @Query(value="start team=node({p_team}) match (team)-[:persons]->(member) return member")
    public Iterable<Person> findAllTeamMembers(@Param(value="p_team") Group var1);

    @Query(value="g.v(team).out('persons')", type=QueryType.Gremlin)
    public Iterable<Person> findAllTeamMembersGremlin(@Param(value="team") Group var1);

    @Query(value="start team=node({p_team}) match (team)-[:persons]->(member) return member.name,member.age")
    public Iterable<Map<String, Object>> findAllTeamMemberData(@Param(value="p_team") Group var1);

    @Query(value="start member=node({p_person}) match team-[:persons]->member<-[?:boss]-boss return collect(team), boss")
    public Iterable<MemberData> findMemberData(@Param(value="p_person") Person var1);

    @Query(value="start member=node({p_person}) match team-[:persons]->member<-[?:boss]-boss return member")
    public Iterable<MemberData> nonWorkingQuery(@Param(value="p_person") Person var1);

    @Query(value="start team=node:Group(name = {p_team}) match (team)-[:persons*1..1]->(member) return member order by member.name skip {`skip`} limit {`limit`}")
    public Iterable<Person> findSomeTeamMembers(@Param(value="p_team") String var1, @Param(value="skip") Integer var2, @Param(value="limit") Integer var3, @Param(value="depth") Integer var4);

    @Query(value="start person=node({p_person}) match (boss)-[:boss]->(person) return boss")
    public Person findBoss(@Param(value="p_person") Person var1);

    @Query(value="start person=node({p_person}) match (boss)-[:boss]->(person) return boss")
    public Person findBoss(@Param(value="p_person") Long var1);

    @Query(value="start boss=node({0}) match (boss)-[:boss]->(person) with person, count(*) as cnt order by cnt return person")
    public Page<Person> findSubordinates(Person var1, Pageable var2);

    @Query(value="start boss=node({0}) match (boss)-[:boss]->(person) with person, count(*) as cnt order by cnt return person", countQuery="start boss=node({0}) match (boss)-[:boss]->(person) with person return count(*)")
    public Page<Person> findSubordinatesWithCount(Person var1, Pageable var2);

    public Group findTeam(@Param(value="p_person") Person var1);

    @Query(value="start team=node({p_team}) match (team)-[:persons]->(member) return member")
    public Page<Person> findAllTeamMembersPaged(@Param(value="p_team") Group var1, Pageable var2);

    @Query(value="start team=node({p_team}) match (team)-[:persons]->(member) return member")
    public Iterable<Person> findAllTeamMembersSorted(@Param(value="p_team") Group var1, Sort var2);

    public Iterable<Person> findByName(String var1);

    public Iterable<Person> findByPersonality(String var1);

    public Iterable<Person> findByAge(int var1);

    @Query(value="start person=node:`name-index`('name:*') return person.name as name, person order by name asc ")
    public Iterable<NameAndPersonResult> getAllNamesAndPeople();

    public EndResult<Person> findByHeight(short var1);

    @MapResult
    public static interface NameAndPersonResult {
        @ResultColumn(value="name")
        public String getName();

        @ResultColumn(value="person")
        public Person getPerson();
    }
}

