/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.index.lucene.ValueContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.neo4j.annotation.GraphId;
import org.springframework.data.neo4j.annotation.GraphProperty;
import org.springframework.data.neo4j.annotation.Indexed;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.repository.query.CypherQueryBuilder;
import org.springframework.data.neo4j.repository.query.CypherQueryDefinition;
import org.springframework.data.neo4j.repository.query.DerivedCypherRepositoryQuery;
import org.springframework.data.neo4j.repository.query.GraphQueryMethod;
import org.springframework.data.neo4j.repository.query.Person;
import org.springframework.data.neo4j.repository.query.RepositoryQueryException;
import org.springframework.data.neo4j.repository.query.ThingRepository;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.index.IndexType;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.DefaultRepositoryMetadata;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.test.context.CleanContextCacheTestExecutionListener;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
@TestExecutionListeners(value={CleanContextCacheTestExecutionListener.class, DependencyInjectionTestExecutionListener.class, TransactionalTestExecutionListener.class})
public class DerivedFinderMethodTests {
    @Autowired
    ThingRepository repository;
    @Autowired
    Neo4jMappingContext ctx;
    @Autowired
    Neo4jTemplate template;

    @Test
    public void testCreateIndexQuery() throws Exception {
        CypherQueryBuilder builder = new CypherQueryBuilder((MappingContext)this.ctx, Thing.class, this.template);
        builder.addRestriction(new Part("firstName", Thing.class));
        builder.addRestriction(new Part("lastName", Thing.class));
        CypherQueryDefinition query = builder.buildQuery();
        Assert.assertEquals((Object)"START `thing`=node:`Thing`({0}) RETURN `thing`", (Object)query.toQueryString());
    }

    @Test
    public void testQueryWithGraphId() throws Exception {
        this.assertRepositoryQueryMethod(ThingRepository.class, "findById", new Object[]{123}, "START `thing`=node({0})", 123);
    }

    @Test
    public void testQueryWithEntityGraphId() throws Exception {
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByOwnerId", new Object[]{123}, "START `thing_owner`=node({0}) MATCH `thing`-[:`owner`]->`thing_owner` WHERE (has(`thing`.__type__) AND `thing`.__type__ IN ['org.springframework.data.neo4j.repository.query.DerivedFinderMethodTests$Thing']) ", 123);
    }

    @Test
    public void testIndexQueryWithTwoParams() throws Exception {
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByFirstNameAndLastName", new Object[]{"foo", "bar"}, "START `thing`=node:`Thing`({0})", "firstName:foo AND lastName:bar");
    }

    @Test
    public void testIndexQueryWithOneParam() throws Exception {
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByFirstName", new Object[]{"foo"}, "START `thing`=node:`Thing`(`firstName`={0})", "foo");
    }

    @Test
    public void testIndexQueryWithOneParamFullText() throws Exception {
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByDescription", new Object[]{"foo"}, "START `thing`=node:`search`({0})", "description:foo");
    }

    @Test
    public void testIndexQueryWithOneParamFullTextAndOneParam() throws Exception {
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByDescriptionAndFirstName", new Object[]{"foo", "bar"}, "START `thing`=node:`search`({0}) WHERE `thing`.`firstName`! = {1}", "description:foo", "bar");
    }

    @Test
    public void testIndexQueryWithOneParamAndOneParamFullText() throws Exception {
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByFirstNameAndDescription", new Object[]{"foo", "bar"}, "START `thing`=node:`Thing`(`firstName`={0}) WHERE `thing`.`description`! = {1}", "foo", "bar");
    }

    @Test
    public void testIndexQueryWithOneNonIndexedParam() throws Exception {
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByAge", new Object[]{100}, "WHERE `thing`.`age`! = {0}", 100);
    }

    @Test
    public void testIndexQueryWithOneNonIndexedParamAndOneIndexedParam() throws Exception {
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByAgeAndFirstName", new Object[]{100, "foo"}, "START `thing`=node:`Thing`(`firstName`={1}) WHERE `thing`.`age`! = {0}", 100, "foo");
    }

    @Test
    public void testIndexQueryWithLikeIndexedParam() throws Exception {
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByFirstNameLike", new Object[]{"foo"}, "START `thing`=node:`Thing`({0})", "firstName:foo");
    }

    @Test
    public void testIndexQueryWithLikeIndexedParamWithSpaces() throws Exception {
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByFirstNameLike", new Object[]{"foo bar"}, "START `thing`=node:`Thing`({0})", "firstName:\"foo bar\"");
    }

    @Test
    public void testIndexQueryWithContainsIndexedParam() throws Exception {
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByFirstNameContains", new Object[]{"foo"}, "START `thing`=node:`Thing`({0})", "firstName:*foo*");
    }

    @Test
    public void testIndexQueryWithStartsWithIndexedParam() throws Exception {
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByFirstNameStartsWith", new Object[]{"foo"}, "START `thing`=node:`Thing`({0})", "firstName:foo*");
    }

    @Test
    public void testIndexQueryWithEndsWithIndexedParam() throws Exception {
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByFirstNameEndsWith", new Object[]{"foo"}, "START `thing`=node:`Thing`({0})", "firstName:*foo");
    }

    @Test(expected=RepositoryQueryException.class)
    public void testFailIndexQueryWithStartsWithIndexedParamWithSpaces() throws Exception {
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByFirstNameStartsWith", new Object[]{"foo bar"}, "START `thing`=node:`Thing`({0})", new Object[0]);
    }

    @Test
    public void testFindBySimpleStringParam() throws Exception {
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByName", new Object[]{"foo"}, "WHERE `thing`.`name`! = {0}", "foo");
    }

    @Test
    public void testFindBySimpleStringParamStartsWith() throws Exception {
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByNameStartsWith", new Object[]{"foo"}, "WHERE `thing`.`name`! =~ {0}", "^foo.*");
    }

    @Test
    public void testFindBySimpleStringParamEndsWith() throws Exception {
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByNameEndsWith", new Object[]{"foo"}, "WHERE `thing`.`name`! =~ {0}", ".*foo$");
    }

    @Test
    public void testFindBySimpleStringParamContains() throws Exception {
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByNameContains", new Object[]{"foo"}, "WHERE `thing`.`name`! =~ {0}", ".*foo.*");
    }

    @Test
    public void testFindBySimpleStringParamLike() throws Exception {
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByNameLike", new Object[]{"foo"}, "WHERE `thing`.`name`! =~ {0}", "foo");
    }

    @Test
    public void testFindBySimpleStringParamNotLike() throws Exception {
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByNameNotLike", new Object[]{"foo"}, "WHERE not( `thing`.`name`! =~ {0} )", "foo");
    }

    @Test
    public void testFindBySimpleStringParamRegexp() throws Exception {
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByNameMatches", new Object[]{"foo"}, "WHERE `thing`.`name`! =~ {0}", "foo");
    }

    @Test
    public void testFindBySimpleBooleanIsTrue() throws Exception {
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByTaggedIsTrue", new Object[0], "WHERE `thing`.`tagged`! = true", new Object[0]);
    }

    @Test
    public void testFindBySimpleBooleanIsFalse() throws Exception {
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByTaggedIsFalse", new Object[0], "WHERE `thing`.`tagged`! = false", new Object[0]);
    }

    @Test
    public void testFindBySimpleStringExists() throws Exception {
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByNameExists", new Object[0], "WHERE has(`thing`.`name`!  )", new Object[0]);
    }

    @Test
    public void testFindBySimpleStringInCollection() throws Exception {
        List<String> param = Arrays.asList("foo");
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByNameIn", new Object[]{param}, "WHERE `thing`.`name`! in {0}", param);
    }

    @Test
    public void testFindBySimpleStringInCollectionOfEnums() throws Exception {
        List<TimeUnit> param = Arrays.asList(TimeUnit.MINUTES);
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByNameIn", new Object[]{param}, "WHERE `thing`.`name`! in {0}", param);
    }

    @Test
    public void testFindBySimpleStringNotInCollection() throws Exception {
        List<String> param = Arrays.asList("foo");
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByNameNotIn", new Object[]{param}, "WHERE not( `thing`.`name`! in {0} )", param);
    }

    @Test
    public void testFindBySimpleDateBefore() throws Exception {
        Date param = new Date(1337L);
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByBornBefore", new Object[]{param}, "WHERE `thing`.`born`! < {0}", param.getTime());
    }

    @Test
    public void testFindBySimpleDateAfter() throws Exception {
        Date param = new Date(1337L);
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByBornAfter", new Object[]{param}, "WHERE `thing`.`born`! > {0}", param.getTime());
    }

    @Test
    public void testFindByNumericIndexedField() throws Exception {
        this.assertRepositoryQueryMethod(ThingRepository.class, "findByNumber", new Object[]{10}, "START `thing`=node:`Thing`(`number`={0})", ValueContext.numeric((Number)10));
    }

    private void assertRepositoryQueryMethod(Class<ThingRepository> repositoryClass, String methodName, Object[] paramValues, String expectedQuery, Object ... expectedParam) {
        Method method = this.methodFor(repositoryClass, methodName);
        DerivedCypherRepositoryQuery derivedCypherRepositoryQuery = new DerivedCypherRepositoryQuery(this.ctx, new GraphQueryMethod(method, (RepositoryMetadata)new DefaultRepositoryMetadata(repositoryClass), null, this.ctx), this.template);
        Parameters parameters = new Parameters(method);
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(parameters, paramValues);
        String query = derivedCypherRepositoryQuery.createQueryWithPagingAndSorting((ParameterAccessor)accessor);
        Map params = derivedCypherRepositoryQuery.resolveParams((ParameterAccessor)accessor);
        String firstWord = expectedQuery.split("\\s+")[0];
        Assert.assertEquals((Object)expectedQuery, (Object)query.substring(query.indexOf(firstWord)).substring(0, expectedQuery.length()));
        Assert.assertEquals((long)expectedParam.length, (long)params.size());
        for (int i = 0; i < expectedParam.length; ++i) {
            if (expectedParam[i] instanceof ValueContext) {
                Assert.assertEquals((Object)((ValueContext)expectedParam[i]).getValue(), (Object)((ValueContext)params.get(String.valueOf(i))).getValue());
                continue;
            }
            Assert.assertEquals((Object)expectedParam[i], params.get(String.valueOf(i)));
        }
    }

    private Method methodFor(Class<? extends Repository> repositoryClass, String methodName) {
        for (Method method : repositoryClass.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        throw new NoSuchMethodError("Method " + methodName + " not found in " + repositoryClass);
    }

    @Test
    @Transactional
    public void testMultipleIndexedFields() throws Exception {
        Thing thing = (Thing)this.repository.save(new Thing("John", "Doe"));
        Assert.assertEquals((Object)thing.id, (Object)this.repository.findByFirstNameAndLastName((String)"John", (String)"Doe").id);
    }

    @NodeEntity
    public static class Thing {
        @GraphId
        Long id;
        @Indexed
        String firstName;
        @Indexed
        int number;
        @Indexed
        String lastName;
        String name;
        boolean tagged;
        @GraphProperty(propertyType=Long.class)
        Date born;
        @Indexed(indexType=IndexType.FULLTEXT, indexName="search")
        String description;
        Person owner;
        int age;

        public Thing() {
        }

        public Thing(String firstName, String lastName) {
            this.firstName = firstName;
            this.lastName = lastName;
        }
    }
}

