/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.support.DelegatingGraphDatabase;
import org.springframework.data.neo4j.support.GraphDatabaseFactory;

public class GraphDatabaseFactoryTests {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldCreateLocalDatabaseFromContext() throws Exception {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("GraphDatabaseFactory-context.xml");
        try {
            GraphDatabase graphDatabase = (GraphDatabase)ctx.getBean("graphDatabase", GraphDatabase.class);
            Assert.assertThat((Object)graphDatabase, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsNull.nullValue())));
            Assert.assertThat((Object)graphDatabase, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(DelegatingGraphDatabase.class)));
        }
        finally {
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldCreateLocalDatabase() throws Exception {
        GraphDatabaseFactory factory = new GraphDatabaseFactory();
        try {
            factory.setStoreLocation("target/test-db");
            GraphDatabase graphDatabase = factory.getObject();
            Assert.assertThat((Object)graphDatabase, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsNull.nullValue())));
            Assert.assertThat((Object)graphDatabase, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(DelegatingGraphDatabase.class)));
        }
        finally {
            factory.shutdown();
        }
    }
}

