/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.query;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.data.neo4j.support.query.QueryParameterConverter;

public class QueryParameterConverterTests {
    private static final QueryParameterConverter queryParameterConverter = new QueryParameterConverter();

    @Test
    public void shouldConvertNullToEmptyMap() throws Exception {
        Assert.assertThat((Object)queryParameterConverter.convert(null), (Matcher)CoreMatchers.is(Collections.emptyMap()));
    }

    @Test
    public void shouldConvertEmptyMapToEmptyMap() throws Exception {
        Assert.assertThat((Object)queryParameterConverter.convert(new HashMap()), (Matcher)CoreMatchers.is(Collections.emptyMap()));
    }

    @Test
    public void shouldConvertSingleNullValue() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("foo", null);
        Assert.assertThat((Object)queryParameterConverter.convert(parameters), (Matcher)CoreMatchers.is(parameters));
    }

    @Test
    public void shouldConvertSinglePrimitiveValue() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("foo", "bar");
        parameters.put("baz", 42L);
        Assert.assertThat((Object)queryParameterConverter.convert(parameters), (Matcher)CoreMatchers.is(parameters));
    }

    @Test
    public void shouldConvertSingleEnumValueUsingDefaultConversion() throws Exception {
        HashMap<String, Suit> parameters = new HashMap<String, Suit>();
        parameters.put("foo", Suit.HEART);
        HashMap<String, String> expectedParameters = new HashMap<String, String>();
        expectedParameters.put("foo", "HEART");
        Assert.assertThat((Object)queryParameterConverter.convert(parameters), (Matcher)CoreMatchers.is(expectedParameters));
    }

    @Test
    public void shouldConvertSingleDateValueUsingDefaultConversion() throws Exception {
        HashMap<String, Date> parameters = new HashMap<String, Date>();
        parameters.put("foo", new Date(42L));
        HashMap<String, String> expectedParameters = new HashMap<String, String>();
        expectedParameters.put("foo", "42");
        Assert.assertThat((Object)queryParameterConverter.convert(parameters), (Matcher)CoreMatchers.is(expectedParameters));
    }

    @Test
    public void shouldConvertArrayOfString() throws Exception {
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        parameters.put("foo", new String[]{"bar", "baz"});
        Assert.assertArrayEquals((Object[])((String[])queryParameterConverter.convert(parameters).get("foo")), (Object[])((String[])parameters.get("foo")));
    }

    @Test
    public void shouldConvertArrayOfPrimitive() throws Exception {
        HashMap<String, long[]> parameters = new HashMap<String, long[]>();
        parameters.put("foo", new long[]{42L, 87L});
        Assert.assertArrayEquals((long[])((long[])queryParameterConverter.convert(parameters).get("foo")), (long[])((long[])parameters.get("foo")));
    }

    @Test
    public void shouldConvertArrayOfEnum() throws Exception {
        HashMap<String, Suit[]> parameters = new HashMap<String, Suit[]>();
        parameters.put("foo", new Suit[]{Suit.HEART, Suit.SPADE});
        Assert.assertArrayEquals((Object[])((String[])queryParameterConverter.convert(parameters).get("foo")), (Object[])new String[]{"HEART", "SPADE"});
    }

    @Test
    public void shouldConvertArrayOfDate() throws Exception {
        HashMap<String, Date[]> parameters = new HashMap<String, Date[]>();
        parameters.put("foo", new Date[]{new Date(42L), new Date(87L)});
        Assert.assertArrayEquals((Object[])((String[])queryParameterConverter.convert(parameters).get("foo")), (Object[])new String[]{"42", "87"});
    }

    @Test
    public void shouldConvertIterableOfString() throws Exception {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        parameters.put("foo", Arrays.asList("bar", "baz"));
        Assert.assertThat((Object)queryParameterConverter.convert(parameters), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(parameters)));
    }

    @Test
    public void shouldConvertIterableOfPrimitive() throws Exception {
        HashMap<String, List<Long>> parameters = new HashMap<String, List<Long>>();
        parameters.put("foo", Arrays.asList(42L, 87L));
        Assert.assertThat((Object)queryParameterConverter.convert(parameters), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(parameters)));
    }

    @Test
    public void shouldConvertIterableOfEnum() throws Exception {
        HashMap<String, List<Suit>> parameters = new HashMap<String, List<Suit>>();
        parameters.put("foo", Arrays.asList(Suit.HEART, Suit.SPADE));
        Assert.assertThat((Object)((List)queryParameterConverter.convert(parameters).get("foo")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(Arrays.asList("HEART", "SPADE"))));
    }

    @Test
    public void shouldConvertIterableOfDate() throws Exception {
        HashMap<String, List<Date>> parameters = new HashMap<String, List<Date>>();
        parameters.put("foo", Arrays.asList(new Date(42L), new Date(87L)));
        Assert.assertThat((Object)((List)queryParameterConverter.convert(parameters).get("foo")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(Arrays.asList("42", "87"))));
    }

    @Test
    public void shouldConvertArrayOfArray() throws Exception {
        HashMap<String, Object[]> parameters = new HashMap<String, Object[]>();
        parameters.put("foo", new Object[]{new String[]{"bar", "baz"}, new Long[]{42L}, new Date[]{new Date(87L)}});
        Object[] foo1 = (Object[])queryParameterConverter.convert(parameters).get("foo");
        Object[] foo2 = (Object[])parameters.get("foo");
        Assert.assertArrayEquals((Object[])((String[])foo1[0]), (Object[])((String[])foo2[0]));
        Assert.assertArrayEquals((Object[])((Long[])foo1[1]), (Object[])((Long[])foo2[1]));
        Assert.assertArrayEquals((Object[])((String[])foo1[2]), (Object[])new String[]{"87"});
    }

    @Test
    public void shouldConvertIterableOfArray() throws Exception {
        HashMap<String, List<Serializable>> parameters = new HashMap<String, List<Serializable>>();
        parameters.put("foo", Arrays.asList(new Serializable[]{new String[]{"bar", "baz"}, new long[]{87L}, new Suit[]{Suit.HEART, Suit.SPADE}}));
        List foo1 = (List)queryParameterConverter.convert(parameters).get("foo");
        List foo2 = (List)parameters.get("foo");
        Assert.assertArrayEquals((Object[])((String[])foo1.get(0)), (Object[])((String[])foo2.get(0)));
        Assert.assertArrayEquals((long[])((long[])foo1.get(1)), (long[])((long[])foo2.get(1)));
        Assert.assertArrayEquals((Object[])((String[])foo1.get(2)), (Object[])new String[]{"HEART", "SPADE"});
    }

    @Test
    public void shouldNotConvertUnknownTypes() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("foo", new Foo());
        parameters.put("bar", Arrays.asList(new Foo(), new Foo()));
        Assert.assertThat((Object)queryParameterConverter.convert(parameters), (Matcher)CoreMatchers.is(parameters));
    }

    class Foo {
        Foo() {
        }
    }

    static enum Suit {
        SPADE,
        HEART;

    }
}

