/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.template;

import java.io.IOException;
import java.util.Iterator;
import javax.transaction.TransactionManager;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.TermQuery;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.impl.transaction.SpringTransactionManager;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.springframework.dao.DataAccessException;
import org.springframework.data.neo4j.conversion.ResultConverter;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.support.DelegatingGraphDatabase;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.index.IndexType;
import org.springframework.data.neo4j.template.GraphCallback;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class Neo4jTemplateApiTests {
    private static final DynamicRelationshipType KNOWS = DynamicRelationshipType.withName((String)"knows");
    private static final DynamicRelationshipType HAS = DynamicRelationshipType.withName((String)"has");
    protected Neo4jTemplate template;
    protected GraphDatabase graphDatabase;
    protected Node referenceNode;
    protected Relationship relationship1;
    protected Node node1;
    protected PlatformTransactionManager transactionManager;
    protected GraphDatabaseService graphDatabaseService;

    @Before
    public void setUp() throws Exception {
        this.graphDatabaseService = this.createGraphDatabaseService();
        this.graphDatabase = this.createGraphDatabase();
        this.transactionManager = this.createTransactionManager();
        this.referenceNode = this.graphDatabase.getReferenceNode();
        this.template = new Neo4jTemplate(this.graphDatabase, this.transactionManager);
        this.createData();
    }

    protected GraphDatabaseService createGraphDatabaseService() throws IOException {
        return new ImpermanentGraphDatabase();
    }

    protected GraphDatabase createGraphDatabase() throws Exception {
        return new DelegatingGraphDatabase(this.graphDatabaseService);
    }

    @Test
    public void testBeginTxWithoutConfiguredTxManager() throws Exception {
        Neo4jTemplate template = new Neo4jTemplate(this.graphDatabase);
        Transaction tx = template.getGraphDatabase().beginTx();
        Node node = template.createNode();
        node.setProperty("name", (Object)"foo");
        tx.success();
        tx.finish();
        Assert.assertNotNull((Object)node.getProperty("name"));
    }

    @Test
    public void testInstantiateEntity() throws Exception {
        Neo4jTemplate template = new Neo4jTemplate(this.graphDatabase, this.transactionManager);
        Transaction tx = template.getGraphDatabase().beginTx();
        Person michael = (Person)template.save((Object)new Person("Michael", 37));
        Assert.assertNotNull((Object)michael.getId());
    }

    protected PlatformTransactionManager createTransactionManager() {
        return new JtaTransactionManager((TransactionManager)new SpringTransactionManager((GraphDatabaseAPI)this.graphDatabaseService));
    }

    private void createData() {
        new TransactionTemplate(this.transactionManager).execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                Neo4jTemplateApiTests.this.referenceNode.setProperty("name", (Object)"node0");
                Neo4jTemplateApiTests.this.graphDatabase.createIndex(Node.class, "node", IndexType.SIMPLE).add((PropertyContainer)Neo4jTemplateApiTests.this.referenceNode, "name", (Object)"node0");
                Neo4jTemplateApiTests.this.node1 = Neo4jTemplateApiTests.this.graphDatabase.createNode(MapUtil.map((Object[])new Object[]{"name", "node1"}));
                Neo4jTemplateApiTests.this.relationship1 = Neo4jTemplateApiTests.this.referenceNode.createRelationshipTo(Neo4jTemplateApiTests.this.node1, (RelationshipType)KNOWS);
                Neo4jTemplateApiTests.this.relationship1.setProperty("name", (Object)"rel1");
                Neo4jTemplateApiTests.this.graphDatabase.createIndex(Relationship.class, "relationship", IndexType.SIMPLE).add((PropertyContainer)Neo4jTemplateApiTests.this.relationship1, "name", (Object)"rel1");
            }
        });
    }

    @After
    public void tearDown() throws Exception {
        if (this.graphDatabaseService != null) {
            this.graphDatabaseService.shutdown();
        }
    }

    @Test
    public void shouldExecuteCallbackInTransaction() throws Exception {
        Node refNode = (Node)this.template.exec((GraphCallback)new GraphCallback<Node>(){

            public Node doWithGraph(GraphDatabase graph) throws Exception {
                Node referenceNode = graph.getReferenceNode();
                referenceNode.setProperty("test", (Object)"testDoInTransaction");
                return referenceNode;
            }
        });
        Assert.assertEquals((String)"same reference node", (Object)this.referenceNode, (Object)refNode);
        this.assertTestPropertySet(this.referenceNode, "testDoInTransaction");
    }

    @Test
    public void shouldRollbackTransactionOnException() {
        try {
            this.template.exec((GraphCallback)new GraphCallback.WithoutResult(){

                public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                    graph.getReferenceNode().setProperty("test", (Object)"shouldRollbackTransactionOnException");
                    throw new RuntimeException("please rollback");
                }
            });
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertThat((Object)((String)this.graphDatabase.getReferenceNode().getProperty("test", (Object)"not set")), (Matcher)CoreMatchers.not((Object)"shouldRollbackTransactionOnException"));
    }

    @Test
    public void shouldRollbackViaStatus() throws Exception {
        new TransactionTemplate(this.transactionManager).execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(final TransactionStatus status) {
                Neo4jTemplateApiTests.this.template.exec((GraphCallback)new GraphCallback.WithoutResult(){

                    public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                        graph.getReferenceNode().setProperty("test", (Object)"shouldRollbackTransactionOnException");
                        status.setRollbackOnly();
                    }
                });
            }
        });
        Assert.assertThat((Object)((String)this.graphDatabase.getReferenceNode().getProperty("test", (Object)"not set")), (Matcher)CoreMatchers.not((Object)"shouldRollbackTransactionOnException"));
    }

    @Test(expected=RuntimeException.class)
    public void shouldNotConvertUserRuntimeExceptionToDataAccessException() {
        this.template.exec((GraphCallback)new GraphCallback.WithoutResult(){

            public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                throw new RuntimeException();
            }
        });
    }

    @Test(expected=DataAccessException.class)
    @Ignore
    public void shouldConvertMissingTransactionExceptionToDataAccessException() {
        Neo4jTemplate template = new Neo4jTemplate(this.graphDatabase, null);
        template.exec((GraphCallback)new GraphCallback.WithoutResult(){

            public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                graph.createNode(null);
            }
        });
    }

    @Test(expected=DataAccessException.class)
    public void shouldConvertNotFoundExceptionToDataAccessException() {
        Neo4jTemplate template = new Neo4jTemplate(this.graphDatabase, this.transactionManager);
        template.exec((GraphCallback)new GraphCallback.WithoutResult(){

            public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                graph.getNodeById(Long.MAX_VALUE);
            }
        });
    }

    @Test(expected=DataAccessException.class)
    public void shouldConvertTemplateNotFoundExceptionToDataAccessException() {
        this.template.getNode(Long.MAX_VALUE);
    }

    @Test
    public void shouldExecuteCallback() throws Exception {
        Long refNodeId = (Long)this.template.exec((GraphCallback)new GraphCallback<Long>(){

            public Long doWithGraph(GraphDatabase graph) throws Exception {
                return graph.getReferenceNode().getId();
            }
        });
        Assert.assertEquals((long)this.referenceNode.getId(), (long)refNodeId);
    }

    @Test
    public void testGetReferenceNode() throws Exception {
        Assert.assertEquals((Object)this.referenceNode, (Object)this.template.getReferenceNode());
    }

    @Test
    public void testCreateNode() throws Exception {
        new TransactionTemplate(this.transactionManager).execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                Node node = Neo4jTemplateApiTests.this.template.createNode(null);
                Assert.assertNotNull((String)"created node", (Object)node);
            }
        });
    }

    @Test
    public void testCreateNodeWithProperties() throws Exception {
        new TransactionTemplate(this.transactionManager).execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                Node node = Neo4jTemplateApiTests.this.template.createNode(MapUtil.map((Object[])new Object[]{"test", "testCreateNodeWithProperties"}));
                Neo4jTemplateApiTests.this.assertTestPropertySet(node, "testCreateNodeWithProperties");
            }
        });
    }

    private void assertTestPropertySet(Node node, String testName) {
        Assert.assertEquals((Object)testName, (Object)node.getProperty("test", (Object)"not set"));
    }

    @Test
    public void testGetNode() throws Exception {
        Node lookedUpNode = this.template.getNode(this.referenceNode.getId());
        Assert.assertEquals((Object)this.referenceNode, (Object)lookedUpNode);
    }

    @Test
    public void testGetRelationship() throws Exception {
        Relationship lookedUpRelationship = this.template.getRelationship(this.relationship1.getId());
        Assert.assertThat((Object)lookedUpRelationship, (Matcher)CoreMatchers.is((Object)this.relationship1));
    }

    @Test
    public void testIndexRelationship() throws Exception {
        Index index = this.graphDatabase.getIndex("relationship");
        Relationship lookedUpRelationship = (Relationship)index.get("name", (Object)"rel1").getSingle();
        Assert.assertThat((String)"same relationship from index", (Object)lookedUpRelationship, (Matcher)CoreMatchers.is((Object)this.relationship1));
    }

    @Test
    public void testIndexNode() throws Exception {
        this.template.index("node", (PropertyContainer)this.node1, "name", (Object)"node1");
        Index index = this.graphDatabase.getIndex("node");
        Node lookedUpNode = (Node)index.get("name", (Object)"node1").getSingle();
        Assert.assertThat((String)"same node from index", (Object)lookedUpNode, (Matcher)CoreMatchers.is((Object)this.node1));
    }

    @Test
    public void testQueryNodes() throws Exception {
        this.assertSingleResult((Object)"node0", (Iterable)this.template.lookup("node", (Object)new TermQuery(new Term("name", "node0"))).to(String.class, (ResultConverter)new PropertyContainerNameConverter()));
    }

    @Test
    public void testRetrieveNodes() throws Exception {
        this.assertSingleResult((Object)"node0", (Iterable)this.template.lookup("node", "name", (Object)"node0").to(String.class, (ResultConverter)new PropertyContainerNameConverter()));
    }

    @Test
    public void testQueryRelationships() throws Exception {
        this.assertSingleResult((Object)"rel1", (Iterable)this.template.lookup("relationship", (Object)new TermQuery(new Term("name", "rel1"))).to(String.class, (ResultConverter)new PropertyContainerNameConverter()));
    }

    @Test
    public void testRetrieveRelationships() throws Exception {
        this.assertSingleResult((Object)"rel1", (Iterable)this.template.lookup("relationship", "name", (Object)"rel1").to(String.class, (ResultConverter)new PropertyContainerNameConverter()));
    }

    @Test
    public void testTraverse() throws Exception {
        TraversalDescription description = Traversal.description().relationships((RelationshipType)KNOWS).evaluator(Evaluators.toDepth((int)1)).evaluator(Evaluators.excludeStartPosition());
        this.assertSingleResult((Object)"node1", (Iterable)this.template.traverse(this.referenceNode, description).to(String.class, (ResultConverter)new PathNodeNameMapper()));
    }

    @Test
    public void shouldFindNextNodeViaCypher() throws Exception {
        this.assertSingleResult((Object)this.node1, (Iterable)this.template.query("start n=node(0) match n-->m return m", null).to(Node.class));
    }

    @Test
    public void shouldFindNextNodeViaGremlin() throws Exception {
        this.assertSingleResult((Object)this.node1, (Iterable)this.template.execute("g.v(0).out", null).to(Node.class));
    }

    @Test
    public void shouldGetDirectRelationship() throws Exception {
        this.assertSingleResult((Object)"rel1", (Iterable)this.template.convert(this.referenceNode.getRelationships()).to(String.class, (ResultConverter)new RelationshipNameConverter()));
    }

    @Test
    public void shouldGetDirectRelationshipForType() throws Exception {
        this.assertSingleResult((Object)"rel1", (Iterable)this.template.convert(this.referenceNode.getRelationships(new RelationshipType[]{KNOWS})).to(String.class, (ResultConverter)new RelationshipNameConverter()));
    }

    @Test
    public void shouldGetDirectRelationshipForTypeAndDirection() throws Exception {
        this.assertSingleResult((Object)"rel1", (Iterable)this.template.convert(this.referenceNode.getRelationships((RelationshipType)KNOWS, Direction.OUTGOING)).to(String.class, (ResultConverter)new RelationshipNameConverter()));
    }

    private <T> void assertSingleResult(T expected, Iterable<T> iterable) {
        Iterator<T> result = iterable.iterator();
        Assert.assertEquals(expected, result.next());
        Assert.assertEquals((Object)false, (Object)result.hasNext());
    }

    @Test
    public void shouldCreateRelationshipWithProperty() throws Exception {
        Relationship relationship = this.template.createRelationshipBetween(this.referenceNode, this.node1, "has", MapUtil.map((Object[])new Object[]{"name", "rel2"}));
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((Object)this.referenceNode, (Object)relationship.getStartNode());
        Assert.assertEquals((Object)this.node1, (Object)relationship.getEndNode());
        Assert.assertEquals((Object)HAS.name(), (Object)relationship.getType().name());
        Assert.assertEquals((Object)"rel2", (Object)relationship.getProperty("name", (Object)"not set"));
    }

    private static class PropertyContainerNameConverter
    extends ResultConverter.ResultConverterAdapter<PropertyContainer, String> {
        private PropertyContainerNameConverter() {
        }

        public String convert(PropertyContainer value, Class<String> type) {
            return (String)value.getProperty("name");
        }
    }

    private static class RelationshipNameConverter
    extends ResultConverter.ResultConverterAdapter<Relationship, String> {
        private RelationshipNameConverter() {
        }

        public String convert(Relationship value, Class<String> type) {
            return (String)value.getProperty("name");
        }
    }

    private static class PathNodeNameMapper
    extends ResultConverter.ResultConverterAdapter<Path, String> {
        private PathNodeNameMapper() {
        }

        public String convert(Path path, Class<String> type) {
            return (String)path.endNode().getProperty("name", (Object)"not set");
        }
    }
}

