/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.template;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.MapUtil;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.template.GraphCallback;
import org.springframework.data.neo4j.template.NeoApiTests;

public class Neo4jTemplateTests
extends NeoApiTests {
    @Test
    public void testRefNode() {
        Node refNodeById = (Node)new Neo4jTemplate(this.graph, this.transactionManager).exec((GraphCallback)new GraphCallback<Node>(){

            public Node doWithGraph(GraphDatabase graph) throws Exception {
                Node refNode = graph.getReferenceNode();
                return graph.getNodeById(refNode.getId());
            }
        });
        Assert.assertEquals((String)"same ref node", (Object)this.graph.getReferenceNode(), (Object)refNodeById);
    }

    @Test
    public void testSingleNode() {
        Neo4jTemplate template = new Neo4jTemplate(this.graph, this.transactionManager);
        template.exec((GraphCallback)new GraphCallback.WithoutResult(){

            public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                Node refNode = graph.getReferenceNode();
                Node node = graph.createNode(MapUtil.map((Object[])new Object[]{"name", "Test", "size", 100}));
                refNode.createRelationshipTo(node, (RelationshipType)Type.HAS);
                Relationship toTestNode = refNode.getSingleRelationship((RelationshipType)Type.HAS, Direction.OUTGOING);
                Node nodeByRelationship = toTestNode.getEndNode();
                Assert.assertEquals((Object)"Test", (Object)nodeByRelationship.getProperty("name"));
                Assert.assertEquals((Object)100, (Object)nodeByRelationship.getProperty("size"));
            }
        });
        template.exec((GraphCallback)new GraphCallback.WithoutResult(){

            public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                Node refNode = graph.getReferenceNode();
                Relationship toTestNode = refNode.getSingleRelationship((RelationshipType)Type.HAS, Direction.OUTGOING);
                Node nodeByRelationship = toTestNode.getEndNode();
                Assert.assertEquals((Object)"Test", (Object)nodeByRelationship.getProperty("name"));
                Assert.assertEquals((Object)100, (Object)nodeByRelationship.getProperty("size"));
            }
        });
    }

    @Test
    public void testRollback() {
        Neo4jTemplate template = new Neo4jTemplate(this.graph, this.transactionManager);
        try {
            template.exec((GraphCallback)new GraphCallback.WithoutResult(){

                public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                    Node node = graph.getReferenceNode();
                    node.setProperty("test", (Object)"test");
                    Assert.assertEquals((Object)"test", (Object)node.getProperty("test"));
                    throw new RuntimeException();
                }
            });
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        template.exec((GraphCallback)new GraphCallback.WithoutResult(){

            public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                Node node = graph.getReferenceNode();
                Assert.assertFalse((boolean)node.hasProperty("test"));
            }
        });
    }

    static enum Type implements RelationshipType
    {
        HAS;

    }
}

