/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.typerepresentation;

import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.support.MappingInfrastructureFactoryBean;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.typerepresentation.TypeRepresentationStrategyFactory;

public class TypeRepresentationTests {
    @Test
    public void testSavingTwiceResultsOnlyInOneTRSCall() throws Exception {
        ImpermanentGraphDatabase db = new ImpermanentGraphDatabase();
        MappingInfrastructureFactoryBean factoryBean = new MappingInfrastructureFactoryBean((GraphDatabaseService)db, null);
        factoryBean.setTypeRepresentationStrategy(TypeRepresentationStrategyFactory.Strategy.SubRef);
        factoryBean.afterPropertiesSet();
        Neo4jTemplate template = new Neo4jTemplate(factoryBean.getObject());
        Transaction tx = db.beginTx();
        Person person = (Person)template.save((Object)new Person());
        person.setName("Bar");
        template.save((Object)person);
        tx.failure();
        tx.finish();
    }
}

