/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.unique;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.springframework.data.neo4j.mapping.Neo4jPersistentTestBase;
import org.springframework.data.neo4j.model.BestFriend;
import org.springframework.data.neo4j.model.Person;

public class UniqueRelationshipTests
extends Neo4jPersistentTestBase {
    @Test
    public void testCreateUniqueRelationship() {
        Person p1 = this.storeInGraph(this.michael);
        Person p2 = this.storeInGraph(this.andres);
        BestFriend bestFriend = new BestFriend(p1, p2, "cypher");
        this.template.save((Object)bestFriend);
        Relationship bestFriendRel = (Relationship)this.template.getPersistentState((Object)bestFriend);
        Assert.assertEquals((Object)bestFriendRel, (Object)((Node)this.template.getPersistentState((Object)this.michael)).getSingleRelationship((RelationshipType)DynamicRelationshipType.withName((String)"BEST_FRIEND"), Direction.OUTGOING));
        Assert.assertEquals((Object)bestFriendRel.getEndNode(), (Object)this.template.getPersistentState((Object)this.andres));
        Assert.assertEquals((Object)"cypher", (Object)bestFriendRel.getProperty("secretName"));
        Assert.assertEquals((Object)bestFriendRel, (Object)this.template.getIndex(BestFriend.class).get("secretName", (Object)"cypher").getSingle());
        Person p3 = this.storeInGraph(this.emil);
        BestFriend bestFriend2 = new BestFriend(p1, p3, "cypher");
        this.template.save((Object)bestFriend2);
        Relationship bestFriend2Rel = (Relationship)this.template.getPersistentState((Object)bestFriend2);
        Assert.assertEquals((Object)bestFriend2Rel, (Object)bestFriendRel);
        Assert.assertEquals((Object)bestFriend2Rel.getEndNode(), (Object)this.template.getPersistentState((Object)this.andres));
        Assert.assertEquals((Object)bestFriendRel, (Object)this.template.getIndex(BestFriend.class).get("secretName", (Object)"cypher").getSingle());
    }

    @Test
    public void testCreateUniqueRelationshipRelatedToVia() {
        Person p1 = this.storeInGraph(this.michael);
        Person p2 = this.storeInGraph(this.andres);
        p1.setBestFriend(p2, "cypher");
        this.template.save((Object)p1);
        BestFriend bestFriend = p1.getBestFriend();
        Relationship bestFriendRel = (Relationship)this.template.getPersistentState((Object)bestFriend);
        Assert.assertEquals((Object)bestFriendRel, (Object)((Node)this.template.getPersistentState((Object)this.michael)).getSingleRelationship((RelationshipType)DynamicRelationshipType.withName((String)"BEST_FRIEND"), Direction.OUTGOING));
        Assert.assertEquals((Object)bestFriendRel.getEndNode(), (Object)this.template.getPersistentState((Object)this.andres));
        Assert.assertEquals((Object)"cypher", (Object)bestFriendRel.getProperty("secretName"));
        Assert.assertEquals((Object)bestFriendRel, (Object)this.template.getIndex(BestFriend.class).get("secretName", (Object)"cypher").getSingle());
        Person p3 = this.storeInGraph(this.emil);
        p1.setBestFriend(p3, "cypher");
        BestFriend bestFriend2 = p1.getBestFriend();
        this.template.save((Object)bestFriend2);
        Relationship bestFriend2Rel = (Relationship)this.template.getPersistentState((Object)bestFriend2);
        Assert.assertEquals((Object)bestFriend2Rel, (Object)bestFriendRel);
        Assert.assertEquals((Object)bestFriend2Rel.getEndNode(), (Object)this.template.getPersistentState((Object)this.andres));
        Assert.assertEquals((Object)bestFriendRel, (Object)this.template.getIndex(BestFriend.class).get("secretName", (Object)"cypher").getSingle());
        p1.setBestFriend(null, null);
        this.template.save((Object)p1);
        Assert.assertEquals(null, (Object)((Node)this.template.getPersistentState((Object)this.michael)).getSingleRelationship((RelationshipType)DynamicRelationshipType.withName((String)"BEST_FRIEND"), Direction.OUTGOING));
        p1.setBestFriend(p3, "cypher");
        this.template.save((Object)p1);
        BestFriend bestFriend3 = p1.getBestFriend();
        Relationship bestFriend3Rel = (Relationship)this.template.getPersistentState((Object)bestFriend3);
        Assert.assertNotSame((Object)bestFriend3Rel, (Object)bestFriendRel);
        Assert.assertEquals((Object)bestFriend3Rel.getEndNode(), (Object)this.template.getPersistentState((Object)this.emil));
        Assert.assertEquals((Object)bestFriend3Rel, (Object)this.template.getIndex(BestFriend.class).get("secretName", (Object)"cypher").getSingle());
    }

    @Test
    public void testDeleteAndRecreateUniqueRelationship() {
        Node n1 = this.template.createNode();
        Node n2 = this.template.createNode();
        Relationship r1 = this.template.getOrCreateRelationship("test", "key", (Object)"value", n1, n2, "type", null);
        this.template.delete((Object)r1);
        Node n3 = this.template.createNode();
        Relationship r2 = this.template.getOrCreateRelationship("test", "key", (Object)"value", n1, n3, "type", null);
        Assert.assertFalse((String)"r1 is returned although being deleted", (boolean)r1.equals(r2));
    }
}

