/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import org.junit.After;
import org.junit.Assert;

public abstract class DocumentingTestBase {
    private static final String DOCBOOK_DIR = "target/docbkx";
    private static final String SRC_TEST_JAVA = "src/test/java";
    protected String title;
    protected String snippetTitle;
    protected String snippet;
    protected String[] paragraphs = new String[0];

    @After
    public void outputDocs() throws IOException {
        File directory = new File(this.docbookDirectory(), "snippets");
        if (directory.isFile() || !directory.exists() && !directory.mkdirs()) {
            throw new RuntimeException("Could not create directory " + directory);
        }
        String name = this.getSnippetName();
        PrintWriter writer = new PrintWriter(new FileWriter(this.getSnippetFileName(directory, name)));
        writer.write(this.createHeader());
        writer.write(this.createTitle());
        writer.write(this.createText());
        writer.write(this.createSnippet());
        writer.write(this.createFooter());
        writer.close();
    }

    private String getSnippetName() {
        String className = this.getClass().getSimpleName();
        return className.replaceAll("Tests?$", "");
    }

    private File docbookDirectory() {
        return new File(new File(this.determineRoot(), this.module()), DOCBOOK_DIR);
    }

    protected File getSnippetFileName(File directory, String name) {
        return new File(directory, name + ".xml");
    }

    protected String createFooter() {
        return String.format("</section>%n", new Object[0]);
    }

    protected String createHeader() {
        return String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>%n<!DOCTYPE section PUBLIC \"-//OASIS//DTD DocBook XML V4.4//EN\" \"http://www.oasis-open.org/docbook/xml/4.4/docbookx.dtd\">%n<section>%n", new Object[0]);
    }

    protected String createTitle() {
        return String.format("<title>%s</title>%n", this.title);
    }

    protected String createText() {
        StringBuilder result = new StringBuilder();
        for (String paragraph : this.paragraphs) {
            result.append(String.format("<para>%n%s%n</para>%n", paragraph));
        }
        return result.toString();
    }

    protected String createSnippet() {
        return String.format("<example>%n           <title>%s</title>%n           <programlisting language=\"java\"><![CDATA[%s]]></programlisting>%n       </example>%n", this.snippetTitle, this.collectSnippet());
    }

    protected String collectSnippet() {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(this.getJavaFile()));
            StringBuilder snippetText = new StringBuilder();
            boolean inSnippet = false;
            while ((line = reader.readLine()) != null) {
                if (line.matches(".*//.+SNIPPET\\s+.*\\b" + this.snippet + "\\b.*")) {
                    inSnippet = !inSnippet;
                    continue;
                }
                if (!inSnippet) continue;
                snippetText.append(line).append(String.format("%n", new Object[0]));
            }
            reader.close();
            return snippetText.toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error generating snippet docs ", ioe);
        }
    }

    protected File getJavaFile() {
        String javaFileName = this.getClass().getName().replaceAll("\\.", Matcher.quoteReplacement(File.separator)) + ".java";
        File javaFile = new File(this.testSourceDirectory(), javaFileName);
        if (!javaFile.exists()) {
            Assert.fail((String)("Snippet File " + javaFile + " does not exist "));
        }
        return javaFile;
    }

    private File testSourceDirectory() {
        return new File(new File(this.determineRoot(), this.module()), SRC_TEST_JAVA);
    }

    private File currentDirectory() {
        return new File(".").getAbsoluteFile().getParentFile();
    }

    protected String module() {
        return "spring-data-neo4j";
    }

    protected File determineRoot() {
        File currentDirectory = this.currentDirectory();
        if (new File(currentDirectory, this.module()).exists()) {
            return currentDirectory;
        }
        if (new File(currentDirectory = currentDirectory.getParentFile(), this.module()).exists()) {
            return currentDirectory;
        }
        throw new IllegalStateException("Can't determine root directory, started at " + this.currentDirectory());
    }
}

