/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.typerepresentation;

import org.neo4j.graphdb.Transaction;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.core.NodeTypeRepresentationStrategy;
import org.springframework.data.neo4j.core.RelationshipTypeRepresentationStrategy;
import org.springframework.data.neo4j.support.index.IndexProvider;
import org.springframework.data.neo4j.support.typerepresentation.AbstractIndexBasedTypeRepresentationStrategy;
import org.springframework.data.neo4j.support.typerepresentation.IndexBasedNodeTypeRepresentationStrategy;
import org.springframework.data.neo4j.support.typerepresentation.IndexBasedRelationshipTypeRepresentationStrategy;
import org.springframework.data.neo4j.support.typerepresentation.LabelBasedNodeTypeRepresentationStrategy;
import org.springframework.data.neo4j.support.typerepresentation.NoopNodeTypeRepresentationStrategy;
import org.springframework.data.neo4j.support.typerepresentation.NoopRelationshipTypeRepresentationStrategy;
import org.springframework.data.neo4j.support.typerepresentation.SubReferenceNodeTypeRepresentationStrategy;

public class TypeRepresentationStrategyFactory {
    private final GraphDatabase graphDatabaseService;
    private final Strategy strategy;
    private IndexProvider indexProvider;

    public TypeRepresentationStrategyFactory(GraphDatabase graphDatabaseService) {
        this(graphDatabaseService, TypeRepresentationStrategyFactory.chooseStrategy(graphDatabaseService), null);
    }

    public TypeRepresentationStrategyFactory(GraphDatabase graphDatabaseService, IndexProvider indexProvider) {
        this(graphDatabaseService, TypeRepresentationStrategyFactory.chooseStrategy(graphDatabaseService), indexProvider);
    }

    public TypeRepresentationStrategyFactory(GraphDatabase graphDatabaseService, Strategy strategy) {
        this(graphDatabaseService, strategy, null);
    }

    public TypeRepresentationStrategyFactory(GraphDatabase graphDatabaseService, Strategy strategy, IndexProvider indexProvider) {
        this.indexProvider = indexProvider;
        this.graphDatabaseService = graphDatabaseService;
        this.strategy = strategy;
    }

    private static Strategy chooseStrategy(GraphDatabase graphDatabaseService) {
        try (Transaction tx = graphDatabaseService.beginTx();){
            if (AbstractIndexBasedTypeRepresentationStrategy.isStrategyAlreadyInUse(graphDatabaseService)) {
                Strategy strategy = Strategy.Indexed;
                return strategy;
            }
            if (SubReferenceNodeTypeRepresentationStrategy.isStrategyAlreadyInUse(graphDatabaseService)) {
                Strategy strategy = Strategy.SubRef;
                return strategy;
            }
            if (LabelBasedNodeTypeRepresentationStrategy.isStrategyAlreadyInUse(graphDatabaseService)) {
                Strategy strategy = Strategy.Labeled;
                return strategy;
            }
            tx.success();
            Strategy strategy = Strategy.Labeled;
            return strategy;
        }
    }

    public NodeTypeRepresentationStrategy getNodeTypeRepresentationStrategy() {
        return this.strategy.getNodeTypeRepresentationStrategy(this.graphDatabaseService, this.indexProvider);
    }

    public RelationshipTypeRepresentationStrategy getRelationshipTypeRepresentationStrategy() {
        return this.strategy.getRelationshipTypeRepresentationStrategy(this.graphDatabaseService, this.indexProvider);
    }

    public void setIndexProvider(IndexProvider indexProvider) {
        this.indexProvider = indexProvider;
    }

    public static enum Strategy {
        SubRef{

            @Override
            public NodeTypeRepresentationStrategy getNodeTypeRepresentationStrategy(GraphDatabase graphDatabaseService, IndexProvider indexProvider) {
                return new SubReferenceNodeTypeRepresentationStrategy(graphDatabaseService);
            }

            @Override
            public RelationshipTypeRepresentationStrategy getRelationshipTypeRepresentationStrategy(GraphDatabase graphDatabaseService, IndexProvider indexProvider) {
                return new NoopRelationshipTypeRepresentationStrategy();
            }
        }
        ,
        Labeled{

            @Override
            public NodeTypeRepresentationStrategy getNodeTypeRepresentationStrategy(GraphDatabase graphDatabaseService, IndexProvider indexProvider) {
                return new LabelBasedNodeTypeRepresentationStrategy(graphDatabaseService);
            }

            @Override
            public RelationshipTypeRepresentationStrategy getRelationshipTypeRepresentationStrategy(GraphDatabase graphDatabaseService, IndexProvider indexProvider) {
                return new IndexBasedRelationshipTypeRepresentationStrategy(graphDatabaseService, indexProvider);
            }
        }
        ,
        Indexed{

            @Override
            public NodeTypeRepresentationStrategy getNodeTypeRepresentationStrategy(GraphDatabase graphDatabaseService, IndexProvider indexProvider) {
                return new IndexBasedNodeTypeRepresentationStrategy(graphDatabaseService, indexProvider);
            }

            @Override
            public RelationshipTypeRepresentationStrategy getRelationshipTypeRepresentationStrategy(GraphDatabase graphDatabaseService, IndexProvider indexProvider) {
                return new IndexBasedRelationshipTypeRepresentationStrategy(graphDatabaseService, indexProvider);
            }
        }
        ,
        Noop{

            @Override
            public NodeTypeRepresentationStrategy getNodeTypeRepresentationStrategy(GraphDatabase graphDatabaseService, IndexProvider indexProvider) {
                return new NoopNodeTypeRepresentationStrategy();
            }

            @Override
            public RelationshipTypeRepresentationStrategy getRelationshipTypeRepresentationStrategy(GraphDatabase graphDatabaseService, IndexProvider indexProvider) {
                return new NoopRelationshipTypeRepresentationStrategy();
            }
        };


        public abstract NodeTypeRepresentationStrategy getNodeTypeRepresentationStrategy(GraphDatabase var1, IndexProvider var2);

        public abstract RelationshipTypeRepresentationStrategy getRelationshipTypeRepresentationStrategy(GraphDatabase var1, IndexProvider var2);
    }
}

