/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.integration.conversion;

import org.neo4j.ogm.session.SessionFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.neo4j.config.Neo4jConfiguration;
import org.springframework.data.neo4j.conversion.MetaDataDrivenConversionService;
import org.springframework.data.neo4j.repository.config.EnableNeo4jRepositories;
import org.springframework.data.neo4j.server.Neo4jServer;
import org.springframework.data.neo4j.server.RemoteServer;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableNeo4jRepositories
@EnableTransactionManagement
public class ConversionServicePersistenceContext
extends Neo4jConfiguration {
    @Bean
    public SessionFactory getSessionFactory() {
        return new SessionFactory(new String[]{"org.springframework.data.neo4j.integration.conversion.domain"});
    }

    @Bean
    public Neo4jServer neo4jServer() {
        return new RemoteServer("http://localhost:7879");
    }

    @Bean
    public ConversionService conversionService() {
        return new MetaDataDrivenConversionService(this.getSessionFactory().metaData());
    }
}

