/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.queries;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.Neo4jIntegrationTestRule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.examples.movies.context.MoviesContext;
import org.springframework.data.neo4j.examples.movies.domain.Cinema;
import org.springframework.data.neo4j.examples.movies.domain.User;
import org.springframework.data.neo4j.examples.movies.repo.CinemaRepository;
import org.springframework.data.neo4j.examples.movies.repo.RatingRepository;
import org.springframework.data.neo4j.examples.movies.repo.UserRepository;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@ContextConfiguration(classes={MoviesContext.class})
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class DerivedQueryTest {
    @ClassRule
    public static Neo4jIntegrationTestRule neo4jRule = new Neo4jIntegrationTestRule(7879);
    private static Session session;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private CinemaRepository cinemaRepository;
    @Autowired
    private RatingRepository ratingRepository;

    @Before
    public void init() throws IOException {
        session = new SessionFactory(new String[]{"org.springframework.data.neo4j.examples.movies.domain"}).openSession(neo4jRule.url());
    }

    @After
    public void clearDatabase() {
        neo4jRule.clearDatabase();
    }

    private void executeUpdate(String cypher) {
        new ExecutionEngine(neo4jRule.getGraphDatabaseService()).execute(cypher);
    }

    @Test
    public void shouldFindUsersByName() {
        this.executeUpdate("CREATE (m:User {name:'Michal'})<-[:FRIEND_OF]-(a:User {name:'Adam'})");
        Collection<User> users = this.userRepository.findByName("Michal");
        Iterator<User> iterator = users.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        User user = iterator.next();
        Assert.assertEquals((Object)"Michal", (Object)user.getName());
        Assert.assertEquals((long)1L, (long)user.getFriends().size());
        Assert.assertEquals((Object)"Adam", (Object)user.getFriends().iterator().next().getName());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldFindUsersByMiddleName() {
        this.executeUpdate("CREATE (m:User {middleName:'Joseph'})<-[:FRIEND_OF]-(a:User {middleName:'Mary', name: 'Joseph'})");
        Collection<User> users = this.userRepository.findByMiddleName("Joseph");
        Iterator<User> iterator = users.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        User user = iterator.next();
        Assert.assertEquals((Object)"Joseph", (Object)user.getMiddleName());
        Assert.assertEquals((long)1L, (long)user.getFriends().size());
        User friend = user.getFriends().iterator().next();
        Assert.assertEquals((Object)"Mary", (Object)friend.getMiddleName());
        Assert.assertEquals((Object)"Joseph", (Object)friend.getName());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldFindNodeEntitiesWithLabels() {
        this.executeUpdate("CREATE (u:User {name:'Michal'}) CREATE (p:Theatre {name:'Picturehouse', city:'London'}) CREATE (r:Theatre {name:'Ritzy', city:'London'}) CREATE (u)-[:VISITED]->(p)");
        Collection<Cinema> cinemas = this.cinemaRepository.findByName("Picturehouse");
        Iterator<Cinema> iterator = cinemas.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Cinema cinema = iterator.next();
        Assert.assertEquals((Object)"Picturehouse", (Object)cinema.getName());
        Assert.assertEquals((long)1L, (long)cinema.getVisited().size());
        Assert.assertEquals((Object)"Michal", (Object)cinema.getVisited().iterator().next().getName());
        Assert.assertFalse((boolean)iterator.hasNext());
        List<Cinema> theatres = this.cinemaRepository.findByLocation("London");
        Assert.assertEquals((long)2L, (long)theatres.size());
        Assert.assertTrue((boolean)theatres.contains(new Cinema("Picturehouse")));
        Assert.assertTrue((boolean)theatres.contains(new Cinema("Ritzy")));
    }

    @Test
    public void shouldFindNodeEntitiesMultipleAndedProperties() {
        this.executeUpdate("CREATE (p:Theatre {name:'Picturehouse', city:'London'}) CREATE (r:Theatre {name:'Ritzy', city:'London'}) CREATE (u:User {name:'Michal'}) CREATE (u)-[:VISITED]->(r)");
        List<Cinema> theatres = this.cinemaRepository.findByNameAndLocation("Ritzy", "London");
        Assert.assertEquals((long)1L, (long)theatres.size());
        Assert.assertEquals((Object)"Michal", (Object)theatres.get(0).getVisited().iterator().next().getName());
    }

    @Test
    public void shouldFindNodeEntititiesMultipleOredProperties() {
        this.executeUpdate("CREATE (p:Theatre {name:'Picturehouse', city:'London'}) CREATE (r:Theatre {name:'Ritzy', city:'London'}) CREATE (u:User {name:'Michal'}) CREATE (u)-[:VISITED]->(r)");
        List<Cinema> theatres = this.cinemaRepository.findByNameOrLocation("Ritzy", "London");
        Assert.assertEquals((long)2L, (long)theatres.size());
    }

    @Test
    public void shouldReturnNoResultsCorrectly() {
        this.executeUpdate("CREATE (p:Theatre {name:'Picturehouse', city:'London'}) CREATE (r:Theatre {name:'Ritzy', city:'London'}) CREATE (u:User {name:'Michal'}) CREATE (u)-[:VISITED]->(r)");
        Collection<Cinema> theatres = this.cinemaRepository.findByName("Does not exist");
        Assert.assertEquals((long)0L, (long)theatres.size());
    }

    @Test
    public void shouldFindNodeEntititiesWithComparisonOperators() {
        this.executeUpdate("CREATE (p:Theatre {name:'Picturehouse', city:'London', capacity:5000}) CREATE (r:Theatre {name:'Ritzy', city:'London', capacity: 7500}) CREATE (u:User {name:'Michal'}) CREATE (u)-[:VISITED]->(r)");
        List<Cinema> theatres = this.cinemaRepository.findByCapacityGreaterThan(3000);
        Assert.assertEquals((long)2L, (long)theatres.size());
        Assert.assertTrue((boolean)theatres.contains(new Cinema("Picturehouse")));
        Assert.assertTrue((boolean)theatres.contains(new Cinema("Ritzy")));
        theatres = this.cinemaRepository.findByCapacityGreaterThan(6000);
        Assert.assertEquals((long)1L, (long)theatres.size());
        Assert.assertEquals((Object)"Ritzy", (Object)theatres.get(0).getName());
        theatres = this.cinemaRepository.findByCapacityLessThan(8000);
        Assert.assertEquals((long)2L, (long)theatres.size());
        Assert.assertTrue((boolean)theatres.contains(new Cinema("Picturehouse")));
        Assert.assertTrue((boolean)theatres.contains(new Cinema("Ritzy")));
        theatres = this.cinemaRepository.findByCapacityLessThan(7000);
        Assert.assertEquals((long)1L, (long)theatres.size());
        Assert.assertEquals((Object)"Picturehouse", (Object)theatres.get(0).getName());
    }

    @Test
    public void shouldFindNodeEntititiesWithMultipleComparisonOperatorsAnded() {
        this.executeUpdate("CREATE (p:Theatre {name:'Picturehouse', city:'London', capacity:5000}) CREATE (r:Theatre {name:'Ritzy', city:'London', capacity: 7500}) CREATE (m:Theatre {name:'Regal', city:'Bombay', capacity: 4500}) CREATE (u:User {name:'Michal'}) CREATE (u)-[:VISITED]->(r)");
        List<Cinema> theatres = this.cinemaRepository.findByLocationAndCapacityGreaterThan("London", 3000);
        Assert.assertEquals((long)2L, (long)theatres.size());
        Assert.assertTrue((boolean)theatres.contains(new Cinema("Picturehouse")));
        Assert.assertTrue((boolean)theatres.contains(new Cinema("Ritzy")));
        theatres = this.cinemaRepository.findByCapacityLessThanAndLocation(6000, "Bombay");
        Assert.assertEquals((long)1L, (long)theatres.size());
        Assert.assertEquals((Object)"Regal", (Object)theatres.get(0).getName());
    }

    @Test
    public void shouldFindNodeEntititiesWithMultipleComparisonOperatorsOred() {
        this.executeUpdate("CREATE (p:Theatre {name:'Picturehouse', city:'London', capacity:5000}) CREATE (r:Theatre {name:'Ritzy', city:'London', capacity: 7500}) CREATE (m:Theatre {name:'Regal', city:'Bombay', capacity: 9000}) CREATE (u:User {name:'Michal'}) CREATE (u)-[:VISITED]->(r)");
        List<Cinema> theatres = this.cinemaRepository.findByLocationOrCapacityLessThan("London", 100);
        Assert.assertEquals((long)2L, (long)theatres.size());
        Assert.assertTrue((boolean)theatres.contains(new Cinema("Picturehouse")));
        Assert.assertTrue((boolean)theatres.contains(new Cinema("Ritzy")));
        theatres = this.cinemaRepository.findByCapacityGreaterThanOrLocation(8000, "Paris");
        Assert.assertEquals((long)1L, (long)theatres.size());
        Assert.assertEquals((Object)"Regal", (Object)theatres.get(0).getName());
    }

    @Test
    public void shouldFindNodeEntititiesWithNestedProperty() {
        this.executeUpdate("CREATE (p:Theatre {name:'Picturehouse', city:'London', capacity:5000}) CREATE (r:Theatre {name:'Ritzy', city:'London', capacity: 7500}) CREATE (u:User {name:'Michal'}) CREATE (u)-[:VISITED]->(r)");
        List<Cinema> theatres = this.cinemaRepository.findByVisitedName("Michal");
        Assert.assertEquals((long)1L, (long)theatres.size());
        Assert.assertTrue((boolean)theatres.contains(new Cinema("Ritzy")));
    }

    @Test
    public void shouldFindNodeEntititiesWithBaseAndNestedProperty() {
        this.executeUpdate("CREATE (p:Theatre {name:'Picturehouse', city:'London', capacity:5000}) CREATE (r:Theatre {name:'Ritzy', city:'London', capacity: 7500}) CREATE (m:Theatre {name:'Regal', city:'Bombay', capacity: 5000}) CREATE (u:User {name:'Michal'}) CREATE (u)-[:VISITED]->(r)  CREATE (u)-[:VISITED]->(m)");
        List<Cinema> theatres = this.cinemaRepository.findByLocationAndVisitedName("London", "Michal");
        Assert.assertEquals((long)1L, (long)theatres.size());
        Assert.assertTrue((boolean)theatres.contains(new Cinema("Ritzy")));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldFindNodeEntititiesWithBaseOrNestedProperty() {
        this.executeUpdate("CREATE (p:Theatre {name:'Picturehouse', city:'London', capacity:5000}) CREATE (r:Theatre {name:'Ritzy', city:'London', capacity: 7500}) CREATE (m:Theatre {name:'The Old Vic', city:'London', capacity: 5000}) CREATE (u:User {name:'Michal'}) CREATE (u)-[:VISITED]->(r)  CREATE (u)-[:VISITED]->(m)");
        List<Cinema> theatres = this.cinemaRepository.findByLocationOrVisitedName("P", "Michal");
        Assert.assertEquals((long)2L, (long)theatres.size());
        Assert.assertTrue((boolean)theatres.contains(new Cinema("Ritzy")));
        Assert.assertTrue((boolean)theatres.contains(new Cinema("The Old Vic")));
    }

    @Test
    public void shouldFindNodeEntitiesWithNestedREProperty() {
        this.executeUpdate("CREATE (m1:Movie {title:'Speed'}) CREATE (m2:Movie {title:'The Matrix'}) CREATE (m:Movie {title:'Chocolat'}) CREATE (u:User {name:'Michal'}) CREATE (u1:User {name:'Vince'})  CREATE (u)-[:RATED {stars:3}]->(m1)  CREATE (u)-[:RATED {stars:4}]->(m2) CREATE (u1)-[:RATED {stars:3}]->m");
        List<User> users = this.userRepository.findByRatingsStars(3);
        Assert.assertEquals((long)2L, (long)users.size());
        Assert.assertTrue((boolean)users.contains(new User("Michal")));
        Assert.assertTrue((boolean)users.contains(new User("Vince")));
    }

    @Test
    public void shouldFindNodeEntititiesWithTwoNestedPropertiesAnded() {
        this.executeUpdate("CREATE (p:Theatre {name:'Picturehouse', city:'London', capacity:5000})  CREATE (r:Theatre {name:'Ritzy', city:'London', capacity: 7500})  CREATE (u:User {name:'Michal'})  CREATE (u)-[:VISITED]->(r)  CREATE (u)-[:VISITED]->(p) CREATE (m1:Movie {name:'San Andreas'})  CREATE (m2:Movie {name:'Pitch Perfect 2'}) CREATE (p)-[:BLOCKBUSTER]->(m1) CREATE (r)-[:BLOCKBUSTER]->(m2)");
        List<Cinema> theatres = this.cinemaRepository.findByVisitedNameAndBlockbusterOfTheWeekName("Michal", "San Andreas");
        Assert.assertEquals((long)1L, (long)theatres.size());
        Assert.assertTrue((boolean)theatres.contains(new Cinema("Picturehouse")));
        theatres = this.cinemaRepository.findByVisitedNameAndBlockbusterOfTheWeekName("Michal", "Tomorrowland");
        Assert.assertEquals((long)0L, (long)theatres.size());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldFindNodeEntititiesWithTwoNestedPropertiesOred() {
        this.executeUpdate("CREATE (p:Theatre {name:'Picturehouse', city:'London', capacity:5000})  CREATE (r:Theatre {name:'Ritzy', city:'London', capacity: 7500})  CREATE (u:User {name:'Michal'})  CREATE (u)-[:VISITED]->(r)  CREATE (u)-[:VISITED]->(p) CREATE (m1:Movie {title:'San Andreas'})  CREATE (m2:Movie {title:'Pitch Perfect 2'}) CREATE (p)-[:BLOCKBUSTER]->(m1) CREATE (r)-[:BLOCKBUSTER]->(m2)");
        List<Cinema> theatres = this.cinemaRepository.findByVisitedNameOrBlockbusterOfTheWeekName("Michal", "San Andreas");
        Assert.assertEquals((long)2L, (long)theatres.size());
        Assert.assertTrue((boolean)theatres.contains(new Cinema("Picturehouse")));
        Assert.assertTrue((boolean)theatres.contains(new Cinema("Ritzy")));
        theatres = this.cinemaRepository.findByVisitedNameOrBlockbusterOfTheWeekName("Vince", "Tomorrowland");
        Assert.assertEquals((long)0L, (long)theatres.size());
    }

    @Test
    public void shouldFindNodeEntititiesWithMultipleNestedPropertiesAnded() {
        this.executeUpdate("CREATE (p:Theatre {name:'Picturehouse', city:'London', capacity:5000})  CREATE (r:Theatre {name:'Ritzy', city:'London', capacity: 7500})  CREATE (u:User {name:'Michal', middleName:'M'}) CREATE (u1:User {name:'Vince', middleName:'M'})  CREATE (u)-[:VISITED]->(p)  CREATE (u1)-[:VISITED]->(r)");
        List<Cinema> theatres = this.cinemaRepository.findByVisitedNameAndVisitedMiddleName("Michal", "M");
        Assert.assertEquals((long)1L, (long)theatres.size());
        Assert.assertTrue((boolean)theatres.contains(new Cinema("Picturehouse")));
        theatres = this.cinemaRepository.findByVisitedNameAndVisitedMiddleName("Vince", "V");
        Assert.assertEquals((long)0L, (long)theatres.size());
    }

    @Test
    public void shouldFindNodeEntititiesWithREAndNestedProperty() {
        this.executeUpdate("CREATE (m1:Movie {title:'Speed'}) CREATE (m2:Movie {title:'The Matrix'}) CREATE (m:Movie {title:'Chocolat'}) CREATE (u:User {name:'Michal'}) CREATE (u1:User {name:'Vince'}) CREATE (g:Genre {name:'Thriller'}) CREATE (u)-[:INTERESTED]->(g)  CREATE (u)-[:RATED {stars:3}]->(m1)  CREATE (u)-[:RATED {stars:4}]->(m2) CREATE (u1)-[:RATED {stars:3}]->m");
        List<User> users = this.userRepository.findByRatingsStarsAndInterestedName(3, "Thriller");
        Assert.assertEquals((long)1L, (long)users.size());
        Assert.assertTrue((boolean)users.contains(new User("Michal")));
    }
}

