/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.queries;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.ogm.metadata.MappingException;
import org.neo4j.ogm.testutil.Neo4jIntegrationTestRule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.examples.movies.context.MoviesContext;
import org.springframework.data.neo4j.examples.movies.domain.User;
import org.springframework.data.neo4j.examples.movies.domain.queryresult.EntityWrappingQueryResult;
import org.springframework.data.neo4j.examples.movies.domain.queryresult.Gender;
import org.springframework.data.neo4j.examples.movies.domain.queryresult.RichUserQueryResult;
import org.springframework.data.neo4j.examples.movies.domain.queryresult.UserQueryResult;
import org.springframework.data.neo4j.examples.movies.domain.queryresult.UserQueryResultInterface;
import org.springframework.data.neo4j.examples.movies.repo.CinemaRepository;
import org.springframework.data.neo4j.examples.movies.repo.UnmanagedUserPojo;
import org.springframework.data.neo4j.examples.movies.repo.UserRepository;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@ContextConfiguration(classes={MoviesContext.class})
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class QueryIntegrationTest {
    @ClassRule
    public static Neo4jIntegrationTestRule neo4jRule = new Neo4jIntegrationTestRule(7879);
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private CinemaRepository cinemaRepository;

    @After
    public void clearDatabase() {
        neo4jRule.clearDatabase();
    }

    private void executeUpdate(String cypher) {
        new ExecutionEngine(neo4jRule.getGraphDatabaseService()).execute(cypher);
    }

    @Test
    public void shouldFindArbitraryGraph() {
        this.executeUpdate("CREATE (dh:Movie {name:'Die Hard'}), (fe:Movie {name: 'The Fifth Element'}), (bw:User {name: 'Bruce Willis'}), (ar:User {name: 'Alan Rickman'}), (mj:User {name: 'Milla Jovovich'}), (mj)-[:ACTED_IN]->(fe), (ar)-[:ACTED_IN]->(dh), (bw)-[:ACTED_IN]->(dh), (bw)-[:ACTED_IN]->(fe)");
        List<Map<String, Object>> graph = this.userRepository.getGraph();
        Assert.assertNotNull(graph);
        int i = 0;
        for (Map<String, Object> properties : graph) {
            ++i;
            Assert.assertNotNull(properties);
        }
        Assert.assertEquals((long)2L, (long)i);
    }

    @Test
    public void shouldFindScalarValues() {
        this.executeUpdate("CREATE (m:User {name:'Michal'})<-[:FRIEND_OF]-(a:User {name:'Adam'})");
        List<Integer> ids = this.userRepository.getUserIds();
        Assert.assertEquals((long)2L, (long)ids.size());
        List<Long> nodeIds = this.userRepository.getUserNodeIds();
        Assert.assertEquals((long)2L, (long)nodeIds.size());
    }

    @Test
    public void shouldFindUserByName() {
        this.executeUpdate("CREATE (m:User {name:'Michal'})<-[:FRIEND_OF]-(a:User {name:'Adam'})");
        User user = this.userRepository.findUserByName("Michal");
        Assert.assertEquals((Object)"Michal", (Object)user.getName());
    }

    @Test
    public void shouldFindTotalUsers() {
        this.executeUpdate("CREATE (m:User {name:'Michal'})<-[:FRIEND_OF]-(a:User {name:'Adam'})");
        int users = this.userRepository.findTotalUsers();
        Assert.assertEquals((long)users, (long)2L);
    }

    @Test
    public void shouldFindUsers() {
        this.executeUpdate("CREATE (m:User {name:'Michal'})<-[:FRIEND_OF]-(a:User {name:'Adam'})");
        Collection<User> users = this.userRepository.getAllUsers();
        Assert.assertEquals((long)users.size(), (long)2L);
    }

    @Test
    public void shouldFindUserByNameWithNamedParam() {
        this.executeUpdate("CREATE (m:User {name:'Michal'})<-[:FRIEND_OF]-(a:User {name:'Adam'})");
        User user = this.userRepository.findUserByNameWithNamedParam("Michal");
        Assert.assertEquals((Object)"Michal", (Object)user.getName());
    }

    @Test
    public void shouldFindUsersAsProperties() {
        this.executeUpdate("CREATE (m:User {name:'Michal'})<-[:FRIEND_OF]-(a:User {name:'Adam'})");
        Iterable<Map<String, Object>> users = this.userRepository.getUsersAsProperties();
        Assert.assertNotNull(users);
        int i = 0;
        for (Map<String, Object> properties : users) {
            ++i;
            Assert.assertNotNull(properties);
        }
        Assert.assertEquals((long)2L, (long)i);
    }

    @Test
    public void shouldFindUsersAndMapThemToConcreteQueryResultObjectCollection() {
        this.executeUpdate("CREATE (g:User {name:'Gary', age:32}), (s:User {name:'Sheila', age:29}), (v:User {name:'Vince', age:66})");
        Assert.assertEquals((String)"There should be some users in the database", (long)3L, (long)this.userRepository.findTotalUsers());
        List<UserQueryResult> expected = Arrays.asList(new UserQueryResult("Sheila", 29), new UserQueryResult("Gary", 32), new UserQueryResult("Vince", 66));
        Iterable<UserQueryResult> queryResult = this.userRepository.retrieveAllUsersAndTheirAges();
        Assert.assertNotNull((String)"The query result shouldn't be null", queryResult);
        Assert.assertEquals(expected, queryResult);
        for (UserQueryResult userQueryResult : queryResult) {
            Assert.assertNotNull((Object)userQueryResult.getUserId());
        }
    }

    @Test(expected=MappingException.class)
    public void shouldThrowMappingExceptionIfQueryResultTypeIsNotManagedInMappingMetadata() {
        this.executeUpdate("CREATE (:User {name:'Colin'}), (:User {name:'Jeff'})");
        UnmanagedUserPojo queryResult = this.userRepository.findIndividualUserAsDifferentObject("Jeff");
        Assert.assertNotNull((String)"The query result shouldn't be null", (Object)queryResult);
        Assert.assertEquals((Object)"Jeff", (Object)queryResult.getName());
    }

    @Test
    public void shouldFindUsersAndMapThemToProxiedQueryResultInterface() {
        this.executeUpdate("CREATE (:User {name:'Morne', age:30}), (:User {name:'Abraham', age:31}), (:User {name:'Virat', age:27})");
        UserQueryResultInterface result = this.userRepository.findIndividualUserAsProxiedObject("Abraham");
        Assert.assertNotNull((String)"The query result shouldn't be null", (Object)result);
        Assert.assertEquals((String)"The wrong user was returned", (Object)"Abraham", (Object)result.getNameOfUser());
        Assert.assertEquals((String)"The wrong user was returned", (long)31L, (long)result.getAgeOfUser());
    }

    @Test
    public void shouldRetrieveUsersByGenderAndConvertToCorrectTypes() {
        this.executeUpdate("CREATE (:User {name:'David Warner', gender:'MALE'}), (:User {name:'Shikhar Dhawan', gender:'MALE'}), (:User {name:'Sarah Taylor', gender:'FEMALE', account: '3456789', deposits:['12345.6','45678.9']})");
        Iterable<RichUserQueryResult> usersByGender = this.userRepository.findUsersByGender(Gender.FEMALE);
        Assert.assertNotNull((String)"The resultant users list shouldn't be null", usersByGender);
        Iterator<RichUserQueryResult> userIterator = usersByGender.iterator();
        Assert.assertTrue((boolean)userIterator.hasNext());
        RichUserQueryResult userQueryResult = userIterator.next();
        Assert.assertEquals((Object)((Object)Gender.FEMALE), (Object)((Object)userQueryResult.getUserGender()));
        Assert.assertEquals((Object)"Sarah Taylor", (Object)userQueryResult.getUserName());
        Assert.assertEquals((Object)BigInteger.valueOf(3456789L), (Object)userQueryResult.getUserAccount());
        Assert.assertArrayEquals((Object[])new BigDecimal[]{BigDecimal.valueOf(12345.6), BigDecimal.valueOf(45678.9)}, (Object[])userQueryResult.getUserDeposits());
        Assert.assertFalse((boolean)userIterator.hasNext());
    }

    @Ignore
    @Test
    public void shouldMapNodeEntitiesIntoQueryResultObjects() {
        this.executeUpdate("CREATE (:User {name:'Abraham'}), (:User {name:'Barry'}), (:User {name:'Colin'})");
        EntityWrappingQueryResult wrappedUser = this.userRepository.findWrappedUserByName("Barry");
        Assert.assertNotNull((String)"The loaded wrapper object shouldn't be null", (Object)wrappedUser);
        Assert.assertNotNull((String)"The enclosed user shouldn't be null", (Object)wrappedUser.getUser());
        Assert.assertEquals((Object)"Barry", (Object)wrappedUser.getUser().getName());
    }

    @Test
    public void shouldSubstituteUserId() {
        this.executeUpdate("CREATE (m:User {name:'Michal'})<-[:FRIEND_OF]-(a:User {name:'Adam'})");
        User michal = this.userRepository.findUserByName("Michal");
        Assert.assertNotNull((Object)michal);
        User user = this.userRepository.loadUserById(michal);
        Assert.assertEquals((Object)"Michal", (Object)user.getName());
    }

    @Test
    public void shouldSubstituteNamedParamUserId() {
        this.executeUpdate("CREATE (m:User {name:'Michal'})<-[:FRIEND_OF]-(a:User {name:'Adam'})");
        User michal = this.userRepository.findUserByName("Michal");
        Assert.assertNotNull((Object)michal);
        User user = this.userRepository.loadUserByNamedId(michal);
        Assert.assertEquals((Object)"Michal", (Object)user.getName());
    }

    @Test
    public void shouldFindIterableUsers() {
        this.executeUpdate("CREATE (m:User {name:'Michal'})<-[:FRIEND_OF]-(a:User {name:'Adam'})");
        Iterable<User> users = this.userRepository.getAllUsersIterable();
        int count = 0;
        for (User user : users) {
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
    }
}

