/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repositories.support;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.neo4j.ogm.session.Session;
import org.springframework.aop.framework.Advised;
import org.springframework.data.neo4j.repository.GraphRepository;
import org.springframework.data.neo4j.repository.GraphRepositoryImpl;
import org.springframework.data.neo4j.repository.support.GraphRepositoryFactory;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=MockitoJUnitRunner.class)
public class GraphRepositoryFactoryTest {
    GraphRepositoryFactory factory;
    @Mock
    Session session;

    @Before
    public void setUp() {
        this.factory = new GraphRepositoryFactory(this.session){};
    }

    @Test
    public void setsUpBasicInstanceCorrectly() throws Exception {
        Assert.assertNotNull((Object)this.factory.getRepository(ObjectRepository.class));
    }

    @Test
    public void allowsCallingOfObjectMethods() {
        ObjectRepository repository = (ObjectRepository)this.factory.getRepository(ObjectRepository.class);
        repository.hashCode();
        repository.toString();
        repository.equals(repository);
    }

    @Test
    public void usesConfiguredRepositoryBaseClass() {
        this.factory.setRepositoryBaseClass(CustomGraphRepository.class);
        ObjectRepository repository = (ObjectRepository)this.factory.getRepository(ObjectRepository.class);
        Assert.assertEquals(CustomGraphRepository.class, (Object)((Advised)repository).getTargetClass());
    }

    static class CustomGraphRepository<T>
    extends GraphRepositoryImpl<T> {
        public CustomGraphRepository(Class<T> clazz, Session session) {
            super(clazz, session);
        }
    }

    private static interface ObjectRepository
    extends GraphRepository<Object> {
        @Transactional
        public Object findOne(Long var1);
    }
}

