/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.examples.friends;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.examples.friends.FriendService;
import org.springframework.data.neo4j.examples.friends.context.FriendContext;
import org.springframework.data.neo4j.examples.friends.domain.Friendship;
import org.springframework.data.neo4j.examples.friends.domain.Person;
import org.springframework.data.neo4j.examples.friends.repo.FriendshipRepository;
import org.springframework.data.neo4j.template.Neo4jOperations;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@ContextConfiguration(classes={FriendContext.class})
@RunWith(value=SpringJUnit4ClassRunner.class)
public class FriendTest
extends MultiDriverTestClass {
    @Autowired
    Session session;
    @Autowired
    Neo4jOperations neo4jTemplate;
    @Autowired
    FriendshipRepository friendshipRepository;
    @Autowired
    FriendService friendService;

    @Test
    public void savingPersonWhenTransactionalShouldWork() {
        this.friendService.createPersonAndFriends();
        this.session.clear();
        Person john = (Person)this.session.loadAll(Person.class, new Filter("firstName", (Object)"John")).iterator().next();
        Assert.assertNotNull((Object)john);
        Assert.assertEquals((long)2L, (long)john.getFriendships().size());
    }

    @Test
    public void circularParamtersShouldNotProduceInfiniteRecursion() {
        Person john = new Person();
        john.setFirstName("John");
        this.neo4jTemplate.save((Object)john);
        Person bob = new Person();
        bob.setFirstName("Bob");
        this.neo4jTemplate.save((Object)bob);
        Friendship friendship1 = john.addFriend(bob);
        friendship1.setTimestamp(System.currentTimeMillis());
        this.neo4jTemplate.save((Object)john);
        Friendship queriedFriendship = this.friendshipRepository.getFriendship(john, bob);
        Assert.assertNotNull((Object)queriedFriendship);
        Assert.assertEquals((Object)"John", (Object)queriedFriendship.getPersonStartNode().getFirstName());
        Assert.assertEquals((Object)"Bob", (Object)queriedFriendship.getPersonEndNode().getFirstName());
    }
}

