/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.examples.movies.domain;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Property;
import org.neo4j.ogm.annotation.Relationship;
import org.springframework.data.neo4j.examples.movies.domain.TempMovie;
import org.springframework.data.neo4j.examples.movies.domain.User;

@NodeEntity(label="Theatre")
public class Cinema {
    private Long id;
    private String name;
    @Property(name="city")
    private String location;
    @Relationship(type="VISITED", direction="INCOMING")
    private Set<User> visited = new HashSet<User>();
    @Relationship(type="BLOCKBUSTER", direction="OUTGOING")
    private TempMovie blockbusterOfTheWeek;
    private int capacity;

    public Cinema() {
    }

    public Cinema(String name) {
        this.name = name;
    }

    public Cinema(String name, int capacity) {
        this.name = name;
        this.capacity = capacity;
    }

    public void addVisitor(User user) {
        this.visited.add(user);
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    @Relationship(type="VISITED", direction="INCOMING")
    public Set<User> getVisited() {
        return this.visited;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public TempMovie getBlockbusterOfTheWeek() {
        return this.blockbusterOfTheWeek;
    }

    public void setBlockbusterOfTheWeek(TempMovie blockbusterOfTheWeek) {
        this.blockbusterOfTheWeek = blockbusterOfTheWeek;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cinema cinema = (Cinema)o;
        return !(this.name == null ? cinema.name != null : !this.name.equals(cinema.name));
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

