/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.integration.conversion.domain;

public class MonetaryAmount {
    private final int amount;

    public MonetaryAmount(int pounds, int pence) {
        this.amount = pounds * 100 + pence;
    }

    public int getAmountAsSubUnits() {
        return this.amount;
    }

    public int hashCode() {
        int prime = 17;
        int result = 1;
        result = 17 * result + (this.amount ^ this.amount >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonetaryAmount)) {
            return false;
        }
        MonetaryAmount other = (MonetaryAmount)obj;
        return this.amount == other.amount;
    }

    public String toString() {
        int pence = this.amount % 100;
        return "\u00a3" + this.amount / 100 + "." + (pence < 10 ? "0" + pence : Integer.valueOf(pence));
    }
}

