/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.transactions;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.examples.movies.context.MoviesContext;
import org.springframework.data.neo4j.examples.movies.domain.User;
import org.springframework.data.neo4j.examples.movies.repo.UserRepository;
import org.springframework.data.neo4j.examples.movies.service.UserService;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@ContextConfiguration(classes={MoviesContext.class})
@RunWith(value=SpringJUnit4ClassRunner.class)
public class TransactionIntegrationTest
extends MultiDriverTestClass {
    private GraphDatabaseService graphDatabaseService = TransactionIntegrationTest.getGraphDatabaseService();
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserService userService;

    @Before
    public void populateDatabase() {
        this.graphDatabaseService.registerTransactionEventHandler((TransactionEventHandler)new TransactionEventHandler.Adapter<Object>(){

            public Object beforeCommit(TransactionData data) throws Exception {
                System.out.println("The request to commit is denied");
                throw new TransactionInterceptException("Deliberate testing exception");
            }
        });
    }

    @Test(expected=Exception.class)
    public void whenImplicitTransactionFailsNothingShouldBeCreated() {
        this.userRepository.save(new User("Michal"));
    }

    @Test(expected=Exception.class)
    public void whenExplicitTransactionFailsNothingShouldBeCreated() {
        this.userService.saveWithTxAnnotationOnInterface(new User("Michal"));
    }

    @Test(expected=Exception.class)
    public void whenExplicitTransactionFailsNothingShouldBeCreated2() {
        this.userService.saveWithTxAnnotationOnImpl(new User("Michal"));
    }

    static class TransactionInterceptException
    extends Exception {
        public TransactionInterceptException(String msg) {
            super(msg);
        }
    }
}

