/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.web.service;

import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.session.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.web.domain.User;
import org.springframework.data.neo4j.web.repo.UserRepository;
import org.springframework.data.neo4j.web.service.UserService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserServiceImpl
implements UserService {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private Session session;

    @Override
    @Transactional
    public User getUserByName(String name) {
        Iterable<User> users = this.findByProperty("name", name);
        if (!users.iterator().hasNext()) {
            return null;
        }
        return users.iterator().next();
    }

    @Override
    @Transactional
    public Collection<User> getNetwork(User user) {
        TreeSet<User> network = new TreeSet<User>(new Comparator<User>(){

            @Override
            public int compare(User u1, User u2) {
                return u1.getName().compareTo(u2.getName());
            }
        });
        this.buildNetwork(user, network);
        network.remove(user);
        return network;
    }

    private void buildNetwork(User user, Set<User> network) {
        for (User friend : user.getFriends()) {
            if (network.contains(friend)) continue;
            network.add(friend);
            this.buildNetwork(friend, network);
        }
    }

    protected Iterable<User> findByProperty(String propertyName, Object propertyValue) {
        return this.session.loadAll(User.class, new Filter(propertyName, propertyValue));
    }
}

