/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.config;

import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.event.Event;
import org.neo4j.ogm.session.event.EventListener;
import org.neo4j.ogm.session.event.EventListenerAdapter;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.util.Assert;

public class Neo4jAuditingEventListener
extends EventListenerAdapter
implements EventListener {
    private final ObjectFactory<IsNewAwareAuditingHandler> auditingHandlerFactory;

    public Neo4jAuditingEventListener(ObjectFactory<IsNewAwareAuditingHandler> auditingHandlerFactory, SessionFactory sessionFactory) {
        Assert.notNull(auditingHandlerFactory, (String)"IsNewAwareAuditingHandler must not be null!");
        this.auditingHandlerFactory = auditingHandlerFactory;
        sessionFactory.register((EventListener)this);
    }

    public void onPreSave(Event event) {
        Object object = event.getObject();
        if (object != null) {
            ((IsNewAwareAuditingHandler)this.auditingHandlerFactory.getObject()).markAudited(object);
        }
    }
}

