/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Iterator;
import java.util.Optional;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.repository.query.FilterBuildersDefinition;
import org.springframework.data.neo4j.repository.query.TemplatedQuery;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.lang.Nullable;

class TemplatedQueryCreator
extends AbstractQueryCreator<TemplatedQuery, FilterBuildersDefinition> {
    private final Class<?> entityType;

    public TemplatedQueryCreator(PartTree tree, Class<?> entityType) {
        super(tree);
        this.entityType = entityType;
    }

    protected FilterBuildersDefinition create(Part part, Iterator<Object> iterator) {
        return FilterBuildersDefinition.forType(this.entityType).startWith(part);
    }

    protected FilterBuildersDefinition and(Part part, FilterBuildersDefinition base, Iterator<Object> iterator) {
        return base.and(part);
    }

    protected FilterBuildersDefinition or(FilterBuildersDefinition base, FilterBuildersDefinition criteria) {
        return base.or(criteria.getBasePart());
    }

    protected TemplatedQuery complete(@Nullable FilterBuildersDefinition filterDefinition, Sort sort) {
        return Optional.ofNullable(filterDefinition).map(FilterBuildersDefinition::buildTemplatedQuery).orElseGet(TemplatedQuery::unfiltered);
    }
}

