/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.support;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.springframework.data.neo4j.config.Neo4jCdiExtension;
import org.springframework.data.neo4j.core.Neo4jOperations;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.repository.support.Neo4jRepositoryFactory;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.data.repository.config.CustomRepositoryImplementationDetector;

@API(status=API.Status.INTERNAL, since="6.0")
public final class Neo4jRepositoryFactoryCdiBean<T>
extends CdiRepositoryBean<T> {
    private final BeanManager beanManager;

    public Neo4jRepositoryFactoryCdiBean(Set<Annotation> qualifiers, Class<T> repositoryType, BeanManager beanManager, CustomRepositoryImplementationDetector detector) {
        super(qualifiers, repositoryType, beanManager, Optional.of(detector));
        this.beanManager = beanManager;
    }

    protected T create(CreationalContext<T> creationalContext, Class<T> repositoryType) {
        Neo4jOperations neo4jOperations = this.getReference(Neo4jOperations.class, creationalContext);
        Neo4jMappingContext mappingContext = this.getReference(Neo4jMappingContext.class, creationalContext);
        return (T)this.create(() -> new Neo4jRepositoryFactory(neo4jOperations, mappingContext), repositoryType);
    }

    private <RT> RT getReference(Class<RT> clazz, CreationalContext<?> creationalContext) {
        Set beans = this.beanManager.getBeans(clazz, new Annotation[]{Neo4jCdiExtension.ANY_BEAN});
        if (beans.size() > 1) {
            beans = beans.stream().filter(b -> b.getQualifiers().contains(Neo4jCdiExtension.DEFAULT_BEAN)).collect(Collectors.toSet());
        }
        Object beanReference = this.beanManager.getReference(this.beanManager.resolve(beans), clazz, creationalContext);
        return (RT)beanReference;
    }
}

