/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.support.oracle;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.pool.OracleDataSource;
import org.springframework.data.jdbc.support.ConnectionContextProvider;
import org.springframework.data.jdbc.support.oracle.ProxyConnectionPreparer;
import org.springframework.jdbc.datasource.SmartDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyDataSource
implements SmartDataSource {
    OracleDataSource oracleDataSurce;
    ProxyConnectionPreparer connectioPreparer;

    public ProxyDataSource(OracleDataSource oracleDataSurce, ConnectionContextProvider contextProvider) {
        if (contextProvider == null) {
            throw new IllegalArgumentException("You must supply a ConnectionContextProvider that provides the user name");
        }
        this.oracleDataSurce = oracleDataSurce;
        this.connectioPreparer = new ProxyConnectionPreparer();
        this.connectioPreparer.setContextProvider(contextProvider);
    }

    public boolean shouldClose(Connection connection) {
        return true;
    }

    public Connection getConnection() throws SQLException {
        Connection conn = this.oracleDataSurce.getConnection();
        return this.connectioPreparer.prepare(conn);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        Connection conn = this.oracleDataSurce.getConnection(username, password);
        return this.connectioPreparer.prepare(conn);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.oracleDataSurce.getLogWriter();
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.oracleDataSurce.setLogWriter(printWriter);
    }

    public void setLoginTimeout(int i) throws SQLException {
        this.oracleDataSurce.setLoginTimeout(i);
    }

    public int getLoginTimeout() throws SQLException {
        return this.oracleDataSurce.getLoginTimeout();
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.oracleDataSurce.unwrap(iface);
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.oracleDataSurce.isWrapperFor(iface);
    }
}

