/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.support.oracle;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.xdb.XMLType;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.data.jdbc.support.oracle.XmlTypeHandler;
import org.springframework.util.Assert;
import org.w3c.dom.Document;

public abstract class AbstractXmlTypeHandler
implements XmlTypeHandler {
    @Override
    public XMLType createXmlType(Object object, Connection conn) throws DataRetrievalFailureException {
        XMLType xml;
        block6: {
            Assert.notNull((Object)object, (String)"XML input source must not be null");
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("XML input source must be of type 'java.lang.String' - received: " + object.getClass().getName());
            }
            try {
                if (object instanceof String) {
                    xml = XMLType.createXML((Connection)conn, (String)((String)object));
                    break block6;
                }
                if (object instanceof InputStream) {
                    xml = XMLType.createXML((Connection)conn, (InputStream)((InputStream)object));
                    break block6;
                }
                if (object instanceof Document) {
                    xml = XMLType.createXML((Connection)conn, (Document)((Document)object));
                    break block6;
                }
                throw new IllegalArgumentException("The provided value is not a supported type: " + object.getClass().getName());
            }
            catch (SQLException sqle) {
                throw new DataRetrievalFailureException("Error while creating XMLType", (Throwable)sqle);
            }
        }
        return xml;
    }

    @Override
    public Object getXmlContent(XMLType data) throws DataRetrievalFailureException {
        Assert.notNull((Object)data, (String)"XMLType input must not be null");
        Object result = null;
        try {
            result = this.extractXmlContent(data);
        }
        catch (SQLException sqle) {
            throw new DataRetrievalFailureException("Error while extracting XML content", (Throwable)sqle);
        }
        return result;
    }

    protected abstract Object extractXmlContent(XMLType var1) throws SQLException;
}

