/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.support.oracle;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.sql.ARRAY;
import oracle.sql.STRUCT;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.jdbc.support.oracle.StructMapper;
import org.springframework.jdbc.core.SqlReturnType;

public class SqlReturnStructArray<T>
implements SqlReturnType {
    private StructMapper<T> mapper;

    public SqlReturnStructArray(StructMapper<T> mapper) {
        this.mapper = mapper;
    }

    public Object getTypeValue(CallableStatement cs, int i, int sqlType, String typeName) throws SQLException {
        ARRAY array = (ARRAY)cs.getObject(i);
        if (array == null) {
            return null;
        }
        Object[] structValues = (Object[])array.getArray();
        ArrayList<T> values = new ArrayList<T>();
        for (int x = 0; x < structValues.length; ++x) {
            Object struct = structValues[x];
            if (struct == null || !(struct instanceof STRUCT)) {
                if (struct == null) {
                    throw new InvalidDataAccessApiUsageException("Expected STRUCT but got 'null'");
                }
                throw new InvalidDataAccessApiUsageException("Expected STRUCT but got " + struct.getClass().getName());
            }
            values.add(this.mapper.fromStruct((STRUCT)struct));
        }
        return values.toArray();
    }
}

