/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.config.oracle;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class RacFailoverInterceptorBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String RETRY_OPERATIONS_INTERCEPTOR_CLASS = "org.springframework.data.jdbc.retry.oracle.RacRetryOperationsInterceptor";
    private static final String RETRY_TEMPLATE_CLASS = "org.springframework.retry.support.RetryTemplate";
    private static final String RAC_FAILOVER_RETRY_POLICY_CLASS = "org.springframework.data.jdbc.retry.oracle.RacFailoverRetryPolicy";
    private static final String RECOVERABLE_ERROR_CODES_ATTRIBUTE = "recoverable-error-codes";
    private static final String MAX_NUMBER_OF_RETRIES_ATTRIBUTE = "max-number-of-retries";
    private static final String BACK_OFF_POLICY_ATTRIBUTE = "back-off-policy";
    private static final String RETRY_OPERATIONS_PROPERTY = "retryOperations";
    private static final String RETRY_POLICY_PROPERTY = "retryPolicy";
    private static final String RECOVERABLE_ERROR_CODES_PROPERTY = "recoverableErrorCodes";
    private static final String MAX_NUMBER_OF_RETRIES_PROPERTY = "maxNumberOfRetries";
    private static final String BACK_OFF_POLICY_PROPERTY = "backOffPolicy";
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    protected String getBeanClassName(Element element) {
        return RETRY_OPERATIONS_INTERCEPTOR_CLASS;
    }

    protected boolean shouldGenerateId() {
        return false;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ArrayList<Integer> recoverableErrorCodesList = new ArrayList<Integer>();
        String recoverableErrorCodes = element.getAttribute(RECOVERABLE_ERROR_CODES_ATTRIBUTE);
        if (StringUtils.hasText((String)recoverableErrorCodes)) {
            String[] parsedRecoverableErrorCodes = StringUtils.tokenizeToStringArray((String)recoverableErrorCodes, (String)",", (boolean)true, (boolean)true);
            for (int i = 0; i < parsedRecoverableErrorCodes.length; ++i) {
                try {
                    recoverableErrorCodesList.add(new Integer(parsedRecoverableErrorCodes[i]));
                    continue;
                }
                catch (NumberFormatException e) {
                    parserContext.getReaderContext().error("Error parsing recoverable error code list: \"" + recoverableErrorCodes + "\"; " + e.getClass().getName() + " - " + e.getMessage(), (Object)element);
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using provided recoverable-error-codes: " + recoverableErrorCodesList));
            }
        }
        String maxNumberOfRetries = element.getAttribute(MAX_NUMBER_OF_RETRIES_ATTRIBUTE);
        if (this.logger.isDebugEnabled() && StringUtils.hasText((String)maxNumberOfRetries)) {
            this.logger.debug((Object)("Using provided max-number-of-retries: " + maxNumberOfRetries));
        }
        String backOffPolicyRef = null;
        if (element.hasAttribute(BACK_OFF_POLICY_ATTRIBUTE)) {
            backOffPolicyRef = element.getAttribute(BACK_OFF_POLICY_ATTRIBUTE);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using provided back-off-policy: " + backOffPolicyRef));
            }
        }
        BeanDefinitionBuilder retryTemplateBuilder = BeanDefinitionBuilder.genericBeanDefinition();
        retryTemplateBuilder.getRawBeanDefinition().setBeanClassName(RETRY_TEMPLATE_CLASS);
        BeanDefinitionBuilder racFailoverRetryPolicyBuilder = BeanDefinitionBuilder.genericBeanDefinition();
        racFailoverRetryPolicyBuilder.getRawBeanDefinition().setBeanClassName(RAC_FAILOVER_RETRY_POLICY_CLASS);
        if (recoverableErrorCodesList.size() > 0) {
            racFailoverRetryPolicyBuilder.addPropertyValue(RECOVERABLE_ERROR_CODES_PROPERTY, recoverableErrorCodesList);
        }
        if (StringUtils.hasText((String)maxNumberOfRetries)) {
            racFailoverRetryPolicyBuilder.addPropertyValue(MAX_NUMBER_OF_RETRIES_PROPERTY, (Object)maxNumberOfRetries);
        }
        retryTemplateBuilder.addPropertyValue(RETRY_POLICY_PROPERTY, (Object)racFailoverRetryPolicyBuilder.getRawBeanDefinition());
        if (StringUtils.hasText((String)backOffPolicyRef)) {
            retryTemplateBuilder.addPropertyReference(BACK_OFF_POLICY_PROPERTY, backOffPolicyRef);
        }
        builder.addPropertyValue(RETRY_OPERATIONS_PROPERTY, (Object)retryTemplateBuilder.getRawBeanDefinition());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using retry policy: " + racFailoverRetryPolicyBuilder.getRawBeanDefinition().getBeanClassName()));
        }
        builder.setRole(1);
    }

    protected void registerBeanDefinition(BeanDefinitionHolder beanDefinitionHolder, BeanDefinitionRegistry beanDefinitionRegistry) {
        super.registerBeanDefinition(beanDefinitionHolder, beanDefinitionRegistry);
    }
}

