/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.jms.support.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.sql.Datum;
import oracle.sql.STRUCT;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.jdbc.jms.support.oracle.DatumMapper;
import org.springframework.data.jdbc.support.oracle.BeanPropertyStructMapper;
import org.springframework.data.jdbc.support.oracle.StructMapper;

public class StructDatumMapper<T>
implements DatumMapper<T> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected String typeName;
    private StructMapper<T> mapper;

    public StructDatumMapper(String typeName, StructMapper<T> mapper) {
        this.typeName = typeName;
        this.mapper = mapper;
    }

    public StructDatumMapper(String typeName, Class<T> targetClass) {
        this.typeName = typeName;
        this.mapper = new BeanPropertyStructMapper<T>(targetClass);
    }

    @Override
    public Datum toDatum(T source, Connection conn) throws SQLException {
        STRUCT struct = this.mapper.toStruct(source, conn, this.typeName);
        return struct;
    }

    @Override
    public T fromDatum(Datum datum) throws SQLException {
        STRUCT struct = (STRUCT)datum;
        T result = this.mapper.fromStruct(struct);
        return result;
    }
}

