/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.config;

import io.r2dbc.spi.ConnectionFactory;
import java.util.Collections;
import java.util.Optional;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.r2dbc.dialect.Database;
import org.springframework.data.r2dbc.dialect.Dialect;
import org.springframework.data.r2dbc.function.DatabaseClient;
import org.springframework.data.r2dbc.function.DefaultReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.function.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.function.convert.R2dbcCustomConversions;
import org.springframework.data.r2dbc.support.R2dbcExceptionTranslator;
import org.springframework.data.r2dbc.support.SqlErrorCodeR2dbcExceptionTranslator;
import org.springframework.data.relational.core.conversion.BasicRelationalConverter;
import org.springframework.data.relational.core.conversion.RelationalConverter;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.util.Assert;

@Configuration
public abstract class AbstractR2dbcConfiguration {
    public abstract ConnectionFactory connectionFactory();

    public Dialect getDialect(ConnectionFactory connectionFactory) {
        return Database.findDatabase(connectionFactory).orElseThrow(() -> new UnsupportedOperationException(String.format("Cannot determine a dialect for %s using %s. Please provide a Dialect.", connectionFactory.getMetadata().getName(), connectionFactory))).defaultDialect();
    }

    @Bean
    public DatabaseClient databaseClient(ReactiveDataAccessStrategy dataAccessStrategy, R2dbcExceptionTranslator exceptionTranslator) {
        Assert.notNull((Object)dataAccessStrategy, (String)"DataAccessStrategy must not be null!");
        Assert.notNull((Object)exceptionTranslator, (String)"ExceptionTranslator must not be null!");
        return DatabaseClient.builder().connectionFactory(this.connectionFactory()).dataAccessStrategy(dataAccessStrategy).exceptionTranslator(exceptionTranslator).build();
    }

    @Bean
    public RelationalMappingContext r2dbcMappingContext(Optional<NamingStrategy> namingStrategy, R2dbcCustomConversions r2dbcCustomConversions) {
        Assert.notNull(namingStrategy, (String)"NamingStrategy must not be null!");
        RelationalMappingContext relationalMappingContext = new RelationalMappingContext(namingStrategy.orElse(NamingStrategy.INSTANCE));
        relationalMappingContext.setSimpleTypeHolder(r2dbcCustomConversions.getSimpleTypeHolder());
        return relationalMappingContext;
    }

    @Bean
    public ReactiveDataAccessStrategy reactiveDataAccessStrategy(RelationalMappingContext mappingContext, R2dbcCustomConversions r2dbcCustomConversions) {
        Assert.notNull((Object)mappingContext, (String)"MappingContext must not be null!");
        BasicRelationalConverter converter = new BasicRelationalConverter((MappingContext)mappingContext, (CustomConversions)r2dbcCustomConversions);
        return new DefaultReactiveDataAccessStrategy(this.getDialect(this.connectionFactory()), (RelationalConverter)converter);
    }

    @Bean
    public R2dbcCustomConversions r2dbcCustomConversions() {
        Dialect dialect = this.getDialect(this.connectionFactory());
        CustomConversions.StoreConversions storeConversions = CustomConversions.StoreConversions.of((SimpleTypeHolder)dialect.getSimpleTypeHolder(), (Object[])new Object[0]);
        return new R2dbcCustomConversions(storeConversions, Collections.emptyList());
    }

    @Bean
    public R2dbcExceptionTranslator exceptionTranslator() {
        return new SqlErrorCodeR2dbcExceptionTranslator(this.connectionFactory());
    }
}

