/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.function.connectionfactory;

import java.util.Stack;
import org.springframework.data.r2dbc.function.connectionfactory.TransactionResources;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ReactiveTransactionSynchronization {
    private Stack<TransactionResources> resources = new Stack();

    public boolean isSynchronizationActive() {
        return !this.resources.isEmpty();
    }

    public void registerTransaction(TransactionResources transactionResources) {
        Assert.notNull((Object)transactionResources, (String)"TransactionContext must not be null!");
        this.resources.push(transactionResources);
    }

    public void unregisterTransaction(TransactionResources transactionResources) {
        Assert.notNull((Object)transactionResources, (String)"TransactionContext must not be null!");
        this.resources.remove(transactionResources);
    }

    @Nullable
    public TransactionResources getCurrentTransaction() {
        if (!this.resources.isEmpty()) {
            return this.resources.peek();
        }
        return null;
    }
}

