/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.support;

import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.r2dbc.function.DatabaseClient;
import org.springframework.data.r2dbc.function.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.function.convert.MappingR2dbcConverter;
import org.springframework.data.r2dbc.repository.query.R2dbcQueryMethod;
import org.springframework.data.r2dbc.repository.query.StringBasedR2dbcQuery;
import org.springframework.data.r2dbc.repository.support.SimpleR2dbcRepository;
import org.springframework.data.relational.core.conversion.BasicRelationalConverter;
import org.springframework.data.relational.core.conversion.RelationalConverter;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.repository.query.RelationalEntityInformation;
import org.springframework.data.relational.repository.support.MappingRelationalEntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.ReactiveRepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class R2dbcRepositoryFactory
extends ReactiveRepositoryFactorySupport {
    private static final SpelExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    private final DatabaseClient databaseClient;
    private final MappingContext<? extends RelationalPersistentEntity<?>, RelationalPersistentProperty> mappingContext;
    private final MappingR2dbcConverter converter;
    private final ReactiveDataAccessStrategy dataAccessStrategy;

    public R2dbcRepositoryFactory(DatabaseClient databaseClient, MappingContext<? extends RelationalPersistentEntity<?>, RelationalPersistentProperty> mappingContext, ReactiveDataAccessStrategy dataAccessStrategy) {
        Assert.notNull((Object)databaseClient, (String)"DatabaseClient must not be null!");
        Assert.notNull(mappingContext, (String)"MappingContext must not be null!");
        Assert.notNull((Object)dataAccessStrategy, (String)"ReactiveDataAccessStrategy must not be null!");
        this.databaseClient = databaseClient;
        this.mappingContext = mappingContext;
        this.dataAccessStrategy = dataAccessStrategy;
        this.converter = new MappingR2dbcConverter((RelationalConverter)new BasicRelationalConverter(mappingContext));
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleR2dbcRepository.class;
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        RelationalEntityInformation entityInformation = this.getEntityInformation(information.getDomainType(), information);
        return this.getTargetRepositoryViaReflection(information, new Object[]{entityInformation, this.databaseClient, this.converter, this.dataAccessStrategy});
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new R2dbcQueryLookupStrategy(this.databaseClient, evaluationContextProvider, this.converter));
    }

    public <T, ID> RelationalEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return this.getEntityInformation(domainClass, null);
    }

    private <T, ID> RelationalEntityInformation<T, ID> getEntityInformation(Class<T> domainClass, @Nullable RepositoryInformation information) {
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass);
        return new MappingRelationalEntityInformation(entity);
    }

    private static class R2dbcQueryLookupStrategy
    implements QueryLookupStrategy {
        private final DatabaseClient databaseClient;
        private final QueryMethodEvaluationContextProvider evaluationContextProvider;
        private final MappingR2dbcConverter converter;

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            R2dbcQueryMethod queryMethod = new R2dbcQueryMethod(method, metadata, factory, this.converter.getMappingContext());
            String namedQueryName = queryMethod.getNamedQueryName();
            if (namedQueries.hasQuery(namedQueryName)) {
                String namedQuery = namedQueries.getQuery(namedQueryName);
                return new StringBasedR2dbcQuery(namedQuery, queryMethod, this.databaseClient, this.converter, EXPRESSION_PARSER, this.evaluationContextProvider);
            }
            if (queryMethod.hasAnnotatedQuery()) {
                return new StringBasedR2dbcQuery(queryMethod, this.databaseClient, this.converter, EXPRESSION_PARSER, this.evaluationContextProvider);
            }
            throw new UnsupportedOperationException("Query derivation not yet supported!");
        }

        R2dbcQueryLookupStrategy(DatabaseClient databaseClient, QueryMethodEvaluationContextProvider evaluationContextProvider, MappingR2dbcConverter converter) {
            this.databaseClient = databaseClient;
            this.evaluationContextProvider = evaluationContextProvider;
            this.converter = converter;
        }
    }
}

